<?php

namespace App\Livewire\Auth\Register;

use App\Models\Address;
use Livewire\Component;
use Illuminate\Http\Request;

use Livewire\Attributes\Layout;
use App\Http\Requests\Customers\CreateCustomerStepTwoRequest;

class RegisterStepTwo extends Component
{
    public $input = [];
    /*public $provinces = null;
    public $cities = null;
    public $districts = null;
    public $subDistricts = null;*/
    // public $address = false;
    //  public $sessionRegister;
    public $country, $province, $city, $district, $subdistrict;

    public function mount(Request $request)
    {
        if (!$request->session()->get('register.stepOne')) {
            $this->back_step_one();
        }

        $sessionRegisterStepTwo = $request->session()->get('register.stepTwo');
        if ($sessionRegisterStepTwo) {
            $this->country = Address::whereName($sessionRegisterStepTwo['country'] ?? '')->first();
            if ($this->country) {
                request()['country'] = $this->country->id;
                $this->province = Address::whereAddressId($this->country->id)->whereName($sessionRegisterStepTwo['province'] ?? '')->first();
                if ($this->province) {
                    request()['province'] = $this->province->id;
                    $this->city = Address::whereAddressId($this->province->id)->whereName($sessionRegisterStepTwo['city'] ?? '')->first();
                    if ($this->city) {
                        request()['city'] = $this->city->id;
                        $this->district = Address::whereAddressId($this->city->id)->whereName($sessionRegisterStepTwo['district'] ?? '')->first();
                        if ($this->district) {
                            request()['district'] = $this->district->id;
                            $this->subdistrict = Address::whereAddressId($this->district->id)->whereName($sessionRegisterStepTwo['subdistrict'] ?? '')->first();
                            if ($this->subdistrict) {
                                request()['subdistrict'] = $this->subdistrict->id;
                            }
                        }
                    }
                }
            }
            $this->input['address'] = $sessionRegisterStepTwo['address'] ?? '';
            $this->input['phone'] = $sessionRegisterStepTwo['phone'] ?? '';
            /*
            $this->input['country'] = $sessionRegisterStepTwo['country'] ?? '';
            if ($this->input['country']) $this->updatedInputCountry($this->input['country']);
            $this->input['province'] = $sessionRegisterStepTwo['province'] ?? '';
            if ($this->input['province']) $this->updatedInputProvince($this->input['province']);
            $this->input['city'] = $sessionRegisterStepTwo['city'] ?? '';
            if ($this->input['city']) $this->updatedInputCity($this->input['city']);
            $this->input['district'] = $sessionRegisterStepTwo['district'] ?? '';
            if ($this->input['district']) $this->updatedInputDistrict($this->input['district']);
            $this->input['subdistrict'] = $sessionRegisterStepTwo['subdistrict'] ?? '';
            $this->input['address'] = $sessionRegisterStepTwo['address'] ?? '';
            $this->input['phone'] = $sessionRegisterStepTwo['phone'] ?? '';
            // if ($this->input['subdistrict']) $this->updatedInputSubdistrict();
            */
        }
    }

    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];
    public function setCountry($object)
    {
        $this->country = Address::find($object['value']);
    }
    public function setProvince($object)
    {
        $this->province = Address::find($object['value']);
    }
    public function setCity($object)
    {
        $this->city = Address::find($object['value']);
    }
    public function setDistrict($object)
    {
        $this->district = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->subdistrict = Address::find($object['value']);
    }

    public function add_address(Request $request)
    {
        $this->update_address();
        (new CreateCustomerStepTwoRequest())->validate($this->input);
        $request->session()->put('register.stepTwo', $this->input);
        $this->redirect(route('register.stepthree', absolute: false), navigate: true);
    }

    public function back_step_one()
    {
        $this->update_address();
        session()->put('register.stepTwo', $this->input);
        $this->redirect(route('register', absolute: false), navigate: true);
    }

    private function update_address()
    {
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? ''
        ]);
    }


    #[Layout('components.layouts.auth')]
    public function render()
    {
        return view('livewire.auth.register.register-step-two');
    }
}
