<?php

namespace App\Livewire\Components\AddressSelect;


use App\Models\Address;
use Illuminate\Support\Collection;
use Asantibanez\LivewireSelect\LivewireSelect;

class AddressModelSelect extends LivewireSelect
{
    public $iconLeading;
    public $iconLeadingOption;
    public $iconLeadingSelected;
    public $iconVariant;
    public $iconClass;
    public $iconVariantSelected;
    public $iconClassSelected;
    public $country;
    public $dependingValue = true;

    public function mount(
        $name,
        $value = null,
        $placeholder = 'Select an option',
        $searchable = false,
        $dependsOn = [],
        $dependsOnValues = [],
        $waitForDependenciesToShow = false,
        $noResultsMessage = 'No provinces found',
        $selectView = 'livewire.components.address-select.select',
        $defaultView = 'livewire.components.address-select.default',
        $searchView = 'livewire.components.address-select.search',
        $searchInputView = 'livewire.components.address-select.search-input',
        $searchOptionsContainer = 'livewire.components.address-select.search-options-container',
        $searchOptionItem = 'livewire.components.address-select.search-option-item',
        $searchSelectedOptionView = 'livewire.components.address-select.search-selected-option',
        $searchNoResultsView = 'livewire.components.address-select.search-no-results-with-add',
        $iconLeading = null,
        $iconLeadingOption = null,
        $iconVariant = 'mini',
        $iconClass = '',
        $iconLeadingSelected = null,
        $iconVariantSelected = 'mini',
        $iconClassSelected = '',
        $extras = []
    ) {
        $this->iconLeading = $iconLeading;
        $this->iconLeadingOption = $iconLeadingOption;
        $this->iconVariant = $iconVariant;
        $this->iconClass = $iconClass;

        $this->iconLeadingSelected = $iconLeadingSelected;
        $this->iconVariantSelected = $iconVariantSelected;
        $this->iconClassSelected = $iconClassSelected;
        $this->name = $name;
        $this->placeholder = $placeholder;

        $this->value = $value;

        $this->searchable = $searchable;
        $this->searchTerm = '';

        $this->dependsOn = $dependsOn;

        $this->dependsOnValues = collect($this->dependsOn)
            ->mapWithKeys(function ($key) use ($dependsOnValues) {
                $value = collect($dependsOnValues)->get($key);

                return [
                    $key => $value,
                ];
            })
            ->toArray();

        $this->waitForDependenciesToShow = $waitForDependenciesToShow;

        $this->noResultsMessage = $noResultsMessage;

        $this->selectView = $selectView;
        $this->defaultView = $defaultView;
        $this->searchView = $searchView;
        $this->searchInputView = $searchInputView;
        $this->searchOptionsContainer = $searchOptionsContainer;
        $this->searchOptionItem = $searchOptionItem;
        $this->searchSelectedOptionView = $searchSelectedOptionView;
        $this->searchNoResultsView = $searchNoResultsView;

        $this->afterMount($extras);
    }

    public function options($searchProvince = null): Collection
    {
        return Address::query()
            ->when($searchProvince, function ($query, $searchProvince) {
                $query->where('name', 'like', "%$searchProvince%");
            })
            ->whereNull('address_id')
            ->orderBy('name')
            ->get()
            ->map(function (Address $address) {
                return [
                    'value' => $address->id,
                    'description' => $address->name,
                ];
            });
    }

    public function selectedOption($value = null)
    {
        $address = Address::find($value);

        return [
            'value' => optional($address)->id,
            'description' => optional($address)->name
        ];
    }

    public function styles()
    {
        return [
            'searchSelectedOption' => 'h-10 py-2 leading-none ps-3 pe-3 rounded-lg border w-full flex items-center bg-white dark:bg-white/10',
            'searchSelectedOptionTitle' => 'w-full text-zinc-700 dark:text-zinc-300 text-left text-base sm:text-sm',
            'searchSelectedOptionReset' => 'h-4 w-4 text-zinc-700 dark:text-zinc-300',

            'search' => 'relative',
            'searchInput' => 'h-10 py-2 text-base sm:text-sm leading-none rounded-lg w-full ps-3 pe-10 block shadow-xs border bg-white dark:bg-white/10 dark:disabled:bg-white/[9%] text-zinc-700 dark:text-zinc-300 disabled:shadow-none',
            'searchOptionsContainer' => 'absolute overflow-y-auto max-h-25 top-0 left-0 mt-12 w-full z-10 border border-zinc-200 dark:border-zinc-600 rounded-lg shadow-xs p-1 bg-white dark:bg-zinc-700 dark:text-white',

            'searchOptionItem' => 'px-2 py-1 hover:bg-zinc-200 hover:dark:bg-zinc-600 cursor-pointer text-sm rounded-lg',
            'searchOptionPlaceholder' => 'px-2 py-1 text-sm rounded-lg',
            'searchOptionItemActive' => 'bg-zinc-600 text-white font-medium',
            'searchOptionItemInactive' => 'dark:bg-zinc-700 bg-white dark:text-white text-gray-600',

            'searchNoResults' => 'px-2 py-1 w-full dark:bg-zinc-700 bg-white dark:text-white text-gray-600 text-center text-xs',
        ];
    }

    public function add()
    {

        $address = Address::whereName($this->searchTerm)->whereNull('address_id')->first();
        if (!$address) {
            $address = Address::create([
                'address_id' => null,
                'name' => $this->searchTerm,
                'description' => 'country'
            ]);
        }
        $this->selectValue($address->id);
    }

    public function render()
    {
        $options = $this->options($this->searchTerm);
        $this->optionsValues = $options->pluck('value')->toArray();
        if ($this->value != null) {
            $selectedOption = $this->selectedOption($this->value);
        }

        $shouldShow = $this->waitForDependenciesToShow
            ? $this->allDependenciesMet()
            : true;

        $styles = $this->styles();

        return view($this->selectView)
            ->with([
                'options' => $options,
                'selectedOption' => $selectedOption ?? null,
                'shouldShow' => $shouldShow,
                'styles' => $styles,
            ]);
    }
}
