<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Str;
use App\Jobs\ImportAddressJob;
use App\Models\PaymentGateway;
use Livewire\Attributes\Title;
use Illuminate\Console\Command;
use Livewire\Attributes\Layout;
//use App\Models\Customers\CustomerPaketStatusLatest;
use App\Models\Billings\Invoice;
use Illuminate\Support\Facades\DB;
use App\Models\Customers\CustomerPaket;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class Update extends Component
{
    public const NEW_VERSION = '2.0.7';

    #[Layout('components.layouts.install')]
    public function render()
    {
        if (version_compare(env('APP_VERSION'), self::NEW_VERSION, '>=')) {
            $this->redirectRoute('home');
        }
        return view('livewire.update');
    }

    public function update()
    {
        Artisan::call('migrate');
        DB::beginTransaction();
        try {
            Artisan::call('db:seed --class=AddWhatsappNotificationMessageTableSeeder');
            Artisan::call('db:seed --class=CreatePermissionSeeder');
            $this->importAddress();
            //Move tripay key from DB to env file
            $tripay = PaymentGateway::whereValue('tripay')->first();
            if ($tripay->is_active) {
                setEnv('TRIPAY_MODE', $tripay->mode ?? env('TRIPAY_MODE'));
                setEnv('TRIPAY_DEV_MERCHANT_ID', $tripay->development_merchant_code ?? env('TRIPAY_DEV_MERCHANT_ID'));
                setEnv('TRIPAY_DEV_PRIVATE_KEY', $tripay->development_secret_key ?? env('TRIPAY_DEV_PRIVATE_KEY'));
                setEnv('TRIPAY_DEV_API_KEY', $tripay->development_api_key ?? env('TRIPAY_DEV_API_KEY'));
                setEnv('TRIPAY_PRODUCTION_MERCHANT_ID', $tripay->merchant_code ?? env('TRIPAY_PRODUCTION_MERCHANT_ID'));
                setEnv('TRIPAY_PRODUCTION_PRIVATE_KEY', $tripay->production_secret_key ?? env('TRIPAY_PRODUCTION_PRIVATE_KEY'));
                setEnv('TRIPAY_PRODUCTION_API_KEY', $tripay->production_api_key ?? env('TRIPAY_PRODUCTION_API_KEY'));
            }


            setEnv('APP_VERSION', self::NEW_VERSION);
            Artisan::call('optimize:clear');
            DB::commit();
            $this->dropColumnPaymentTable();
            $this->redirectRoute('home');
        } catch (\Exception $e) {
            DB::rollBack();
            throw new \Exception($e->getMessage());
        }
    }

    private function dropColumnPaymentTable()
    {
        Schema::table('payment_gateways', function (Blueprint $table) {
            if (Schema::hasColumn('payment_gateways', 'mode')) {
                $table->dropColumn('mode');
            }
            if (Schema::hasColumn('payment_gateways', 'development_merchant_code')) {
                $table->dropColumn('development_merchant_code');
            }
            if (Schema::hasColumn('payment_gateways', 'development_secret_key')) {
                $table->dropColumn('development_secret_key');
            }
            if (Schema::hasColumn('payment_gateways', 'development_api_key')) {
                $table->dropColumn('development_api_key');
            }
            if (Schema::hasColumn('payment_gateways', 'merchant_code')) {
                $table->dropColumn('merchant_code');
            }
            if (Schema::hasColumn('payment_gateways', 'production_secret_key')) {
                $table->dropColumn('production_secret_key');
            }
            if (Schema::hasColumn('payment_gateways', 'production_api_key')) {
                $table->dropColumn('production_api_key');
            }
        });
    }
    private function importAddress()
    {
        if (cache()->get('processing_import_address')) {
            $this->warn('Processing import address is already running');
            return Command::FAILURE;
        }
        // Address::truncate();

        cache()->put('processing_import_address', true, 60); // Lock for 60 minutes

        try {

            dispatch(new ImportAddressJob())->onQueue('default');
            return Command::SUCCESS;
        } catch (\Exception $e) {
            cache()->forget('processing_import_address');
            $this->error("Error processing import address: " . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
