<?php

namespace App\Observers;

use App\Jobs\SendWhatsappJob;
use Illuminate\Support\Facades\DB;
use App\Models\Customers\UserBootMessage;
use App\Models\WhatsappGateway\WhatsappGatewayGeneral;

class UserBootMessageObserver
{
    /**
     * Handle the CustomerPaket "deleted" event.
     */
    public function deleted(UserBootMessage $userBootMessage): void
    {

    }

    protected function pruning(UserBootMessage $userBootMessage): void
    {
        $waGateway = WhatsappGatewayGeneral::first();
        $delay = env('QUEUE_CONNECTION') === 'database' ? DB::table('jobs')->where('queue', 'send-whatsapp')->count() * 10 : 0;
        $message = 'Terima kasih telah menghubungi asisten WindaNet. Jika anda masih membutuhkan informasi yang lain. Silahkan hubungi saya kembali.';
        $bootNumber = $waGateway->bootNumberMessage();
        dispatch(new SendWhatsappJob($userBootMessage->phone_number, $message, $bootNumber))->onQueue('send-whatsapp')->delay($delay);
    }
}
