<?php

namespace App\Providers;

use App\Models\Billings\Invoice;
use App\Models\Billings\Payment;
use App\Observers\InvoiceObserver;
use App\Observers\PaymentObserver;
use App\Models\Customers\CustomerPaket;
use App\Models\Customers\UserBootMessage;
use Illuminate\Support\ServiceProvider;
use App\Observers\CustomerPaketObserver;
use App\Observers\UserBootMessageObserver;

class EventServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        CustomerPaket::observe(CustomerPaketObserver::class);
        Invoice::observe(InvoiceObserver::class);
        Payment::observe(PaymentObserver::class);
        UserBootMessage::observe(UserBootMessageObserver::class);
    }
}
