<?php

namespace App\Services\Billings;

use App\Models\Websystem;
use Illuminate\Support\Str;
use App\Traits\WebSystemTrait;
use Illuminate\Support\Carbon;
use App\Models\Billings\Invoice;
use App\Traits\CustomerPaketTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\Billings\InvoiceItem;
use App\Services\GeneralLogServices;
use Illuminate\Support\Facades\Auth;
use App\Services\Billings\TaxService;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;
use App\Services\Billings\PricingService;
use App\Services\Payments\PaymentService;
use App\Services\Billings\DeadlineService;
use App\Livewire\Actions\Billings\InvoiceAction;
use App\Services\WhatsappGateway\WhatsappNotificationService;


class BillingService
{
    use WebSystemTrait, CustomerPaketTrait;
    protected $pricingService, $deadlineService, $customerPaketService, $paymentService, $exportInvoiceService;
     protected $generalLogServices;
    protected $taxService;
    public function __construct(
        PricingService $pricingService = null,
        DeadlineService $deadlineService = null,
        CustomerPaketService $customerPaketService = null,
        // WhatsappNotificationService $whatsappNotificationService = null,
        PaymentService $paymentService = null,
        TaxService $taxService = null,
        ExportInvoiceService $exportInvoiceService = null,
        GeneralLogServices $generalLogServices = null
    ) {
        $this->pricingService = $pricingService ?? new PricingService();
        $this->deadlineService = $deadlineService ?? new DeadlineService();
        $this->customerPaketService = $customerPaketService ?? new CustomerPaketService();
        //$this->whatsappNotificationService = $whatsappNotificationService ?? new WhatsappNotificationService();
        $this->paymentService = $paymentService ?? new PaymentService();
        $this->taxService = $taxService ?? new TaxService();
        $this->exportInvoiceService = $exportInvoiceService ?? new ExportInvoiceService();
        $this->generalLogServices = $generalLogServices ?? new GeneralLogServices();
    }

    public function generateInvoice(CustomerPaket $customerPaket)
    {
        // $invoice = (new InvoiceAction())->create_invoice(
        //     $customerPaket,
        //     $this->generateInvoiceNumber()
        // );

        $intervalInvoiceDay = $this->different_day_create_billing();
        $renewalPeriod = $this->getRenewalPeriod($customerPaket->renewal_period);

        $mikrotikAutoIsolir = $customerPaket->mikrotik->auto_isolir;
        if ($mikrotikAutoIsolir->activation_date) {
            if ($this->isPrabayar()) {
                // dd($customerPaket->expired_date);
                $startInvoicePeriod = Carbon::parse(is_null($customerPaket->expired_date) ? Carbon::now() : $customerPaket->expired_date);
                $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add($renewalPeriod);
                $nextBilledAt = Carbon::parse($endInvoicePeriod)->subDays($intervalInvoiceDay);
                $dueDate = $startInvoicePeriod;
            } else {
                $startInvoicePeriod = Carbon::parse($customerPaket->start_date);
                $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add($renewalPeriod);
                $nextBilledAt = Carbon::parse($customerPaket->expired_date)->subDays($intervalInvoiceDay)->add($renewalPeriod);
                $dueDate = $endInvoicePeriod;
            }
        } else {
            if ($this->isPrabayar()) {
                $startInvoicePeriod = Carbon::parse(is_null($customerPaket->expired_date) ? Carbon::now()->setDay((int)$mikrotikAutoIsolir->due_date) : $customerPaket->expired_date);
                $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add($renewalPeriod);
                $nextBilledAt = Carbon::parse($endInvoicePeriod)->subDays($intervalInvoiceDay);
                $dueDate = $startInvoicePeriod;
            } else {
                $startInvoicePeriod = Carbon::parse(is_null($customerPaket->start_date) ? Carbon::now()->setDay((int)$mikrotikAutoIsolir->due_date) : $customerPaket->start_date);
                $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add($renewalPeriod);
                $nextBilledAt = Carbon::parse($customerPaket->expired_date)->subDays($intervalInvoiceDay)->add($renewalPeriod);
                $dueDate = $endInvoicePeriod;
            }
        }

        $invoicePeriod = Carbon::parse($startInvoicePeriod)->startOfMonth();

        $itemInvoice = $this->generateItemInvoice($customerPaket);
        $invoice = new Invoice([
            'user_customer_id' => $customerPaket->user->user_customer->id,
            'customer_paket_id' => $customerPaket->id,
            'periode' => $invoicePeriod,
            'invoice_number' => $this->generateInvoiceNumber(),
            'issue_date' => now(),
            'due_date' => $dueDate,
            'start_periode' => $startInvoicePeriod,
            'end_periode' =>  $endInvoicePeriod,
            'status' => 'pending',
            'amount' => $itemInvoice->price,
            'tax' => $itemInvoice->tax,
            'discount' => $itemInvoice->discount

        ]);

        $invoiceFile = $this->exportInvoiceService->create_invoice_file($invoice);

        $invoice->forceFill([
            'invoice_path' => $invoiceFile
        ])->save();
        $customerPaket->forceFill([
            'next_billed_at' => $nextBilledAt
        ])->save();
         $this->generalLogServices->create_invoice($customerPaket, $invoicePeriod, Auth::user()? Auth::user()->full_name : 'system');
        $invoice->invoice_item()->save($itemInvoice);
        return $invoice;
    }

    protected function generateItemInvoice(CustomerPaket $customerPaket)
    {
        // Create invoice with calculated amount
        /* InvoiceItem::create([
            'invoice_id' => $invoice->id,
            'item' => $invoice->customer_paket->paket->name . ' - ' . Carbon::parse($invoice->customer_paket->start_periode)->format('d F Y') . ' - ' . Carbon::parse($invoice->customer_paket->end_periode)->format('d F Y'),
            'price' => $invoice->customer_paket->price,
            'discount' => $invoice->customer_paket->discount,
            'tax' => $this->calculateTax($invoice->customer_paket->price - $invoice->customer_paket->discount)
        ]);

        $invoice->amount =  $invoice->invoice_items()->sum('price');
        $invoice->tax = $invoice->invoice_items()->sum('tax');
        $invoice->discount = $invoice->invoice_items()->sum('discount');
        $invoice->save();
        return $invoice;
        */
        return new InvoiceItem([
            'item' => $customerPaket->paket->name . ' - ' . Carbon::parse($customerPaket->start_periode)->format('d F Y') . ' - ' . Carbon::parse($customerPaket->end_periode)->format('d F Y'),
            'price' => $customerPaket->price,
            'discount' =>  $customerPaket->discount,
            'tax' =>  $this->calculateTax($customerPaket->price - $customerPaket->discount)
        ]);
    }

    public function generateInvoiceNumber()
    {
        return 'INV-' . Carbon::now()->format('dmY') . strtoupper(uniqid());
    }

    public function createInvoiceWithChunk()
    {
        CustomerPaket::whereStatus('active')->chunk(100, function ($customerPakets) {
            foreach ($customerPakets as $customerPaket) {
                $nextBilledAt =  Carbon::parse($customerPaket->next_billed_at);
                if ($customerPaket->needsBilling($nextBilledAt)) {
                    $this->generateInvoice($customerPaket);
                }
            }
        });

        /*
        $insert_data_invoice_customer_paket = [];
        $insert_data_item_invoice = [];
        $lastInvoice = Invoice::orderBy('id', 'desc')->first();
        if ($lastInvoice) {
            $lastInvoiceId = $lastInvoice->id;
        } else {
            $lastInvoiceId = 1;
        }

        $customerPakets = CustomerPaket::whereStatus('active')->get();
        foreach ($customerPakets as $customerPaket) {
            $renewalPeriod = $this->getRenewalPeriod($customerPaket->renewal_period);
            $intervalInvoiceDay = $this->different_day_create_billing();
            $expiredDate = $customerPaket->expired_date;
            $nextBilled = Carbon::parse($expiredDate)->subDays($intervalInvoiceDay);
            if ($nextBilled->isPast()) {
                $paket = $customerPaket->paket;
                $mikrotik = $customerPaket->mikrotik;
                $startDate = Carbon::parse($customerPaket->start_date);
                $lastInvoiceId = ++$lastInvoiceId;
                $mikrotikAutoIsolir = $mikrotik->auto_isolir;
                if ($mikrotikAutoIsolir->activation_date) {
                    if ($this->isPrabayar()) {
                        $startInvoicePeriod = Carbon::parse($expiredDate);
                        $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add($renewalPeriod);
                        $nextBilled = Carbon::parse($endInvoicePeriod)->subDays($intervalInvoiceDay);
                        $dueDate = $startInvoicePeriod;
                    } else {
                        $startInvoicePeriod = Carbon::parse($startDate);
                        $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add('1 month');
                        $nextBilled = Carbon::parse($expiredDate)->subDays($intervalInvoiceDay)->add('1 month');
                        $dueDate = $endInvoicePeriod;
                    }
                } else {
                    if ($this->isPrabayar()) {
                        $startInvoicePeriod = Carbon::parse($expiredDate);
                        $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add('1 month');
                        $nextBilled = Carbon::parse($endInvoicePeriod)->subDays($intervalInvoiceDay);
                        $dueDate = $startInvoicePeriod;
                    } else {
                        $startInvoicePeriod = Carbon::parse($startDate);
                        $endInvoicePeriod = Carbon::parse($startInvoicePeriod)->add('1 month');
                        $nextBilled = Carbon::parse($expiredDate)->subDays($intervalInvoiceDay)->add('1 month');
                        $dueDate = $endInvoicePeriod;
                    }
                }

                $invoicePeriod = Carbon::parse($startInvoicePeriod)->startOfMonth();
                $insert_data_invoice_customer_paket[] = [
                    'id' => $lastInvoiceId,
                    'user_customer_id' => $customerPaket->user->user_customer->id,
                    'customer_paket_id' => $customerPaket->id,
                    'periode' => $invoicePeriod->format('Y-m-d'),
                    'invoice_number' => $this->generateInvoiceNumber(),
                    'issue_date' => Carbon::now()->format('Y-m-d h:i:s'),
                    'due_date' => $dueDate->format('Y-m-d h:i:s'),
                    'start_periode' => $startInvoicePeriod->format('Y-m-d h:i:s'),
                    'end_periode' =>  $endInvoicePeriod->format('Y-m-d h:i:s'),
                    'status' => 'pending',
                ];

                $insert_data_item_invoice[] = [
                    'invoice_id' => $lastInvoiceId,
                    'item' => $paket->name . ' - ' . Carbon::parse($startInvoicePeriod)->format('d F Y') . ' - ' . Carbon::parse($endInvoicePeriod)->format('d F Y'),
                    'price' => $paket->price,
                    'discount' => 0,
                    'tax' => $this->calculateTax($paket->price)
                ];
            }
        }

        foreach (array_chunk($insert_data_invoice_customer_paket, 500) as $key => $invoice_customer_paket) {
            Invoice::insert($invoice_customer_paket);
        }
        foreach (array_chunk($insert_data_item_invoice, 500) as $key => $item_invoice) {
            InvoiceItem::insert($item_invoice);
        }
            */
    }
}
