<?php

namespace App\Services\WhatsappGateway;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\ServerException;
use Illuminate\Support\Facades\Log;
use App\Models\Websystem;

class GatewayApiService
{

    public static function initializeRequest($endpoint, $input)
    {

        $guzzle = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {
            //$user = Auth::user();
            $company = Websystem::first();
            $response = $guzzle->post($endpoint, [
                "json" => [
                    'name' => $company->title ?? config('app.name'),
                    'email' => $company->email,
                    'password' => $input['password'] ?? null,
                    'domain' => config('app.url'),
                    'company' => $company->title ?? config('app.name'),
                    'phone' => $company->phone,
                ]
            ]);

            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }

    public static function createRequest($endpoint)
    {
        $client = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {
            $response = $client->get($endpoint . '/create', [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_SECRET'),
                    'Accept' => 'application/json'
                ],
            ]);
            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }

    public static function addRequest($endpoint, array $input)
    {
        $client = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {

            $response = $client->post($endpoint, [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_SECRET'),
                    'Accept' => 'application/json'
                ],
                "json" => $input
            ]);
            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }

    public static function updateRequest($endpoint, $id, array $input)
    {
        $client = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {
            $response = $client->put($endpoint . '/' . $id, [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_SECRET'),
                    'Accept' => 'application/json'
                ],
                "json" => $input
            ]);

            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }
    public static function deleteRequest($endpoint, $id, array $input = null)
    {
        $guzzle = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {
            $response = $guzzle->delete($endpoint . '/' . $id, [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_SECRET'),
                    'Accept' => 'application/json'
                ],
                "json" => $input
            ]);
            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }


    public static function getRequest($endpoint, array $input = null)
    {
        $client = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {
            $response = $client->get($endpoint, [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_SECRET'),
                    'Accept' => 'application/json'
                ],
                "json" => $input
            ]);
            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }

    public static function showRequest($endpoint, $id)
    {
        $guzzle = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {
            $response = $guzzle->get($endpoint . '/' . $id, [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_SECRET'),
                    'Accept' => 'application/json'
                ],
            ]);
            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }

    public static function sendMessage($endpoint, array $input)
    {
        $send_wa = $endpoint . '?sender=' . $input['sender'] . '&number=' . $input['number'] . '&message=' . $input['message'];
        $client = new Client([
            'base_uri' => 'https://' . config('wa-griyanet.server_url'),
            'verify' => false
        ]);

        try {
            $response = $client->post($send_wa, [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_MESSAGE'),
                    'Accept' => 'application/json'
                ],
                //"json" => [
                //    'sender' => $input['sender'],
                //    'number' => $input['number'],
                //    'message' => $input['message']
                // ]
            ]);

            return [
                'success' => true,
                'status_code' => $response->getStatusCode(),
                'payload' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (ConnectException $e) {
            Log::error('Guzzle ConnectException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ClientException $e) {
            // Handle 4xx client errors (e.g., 404 Not Found, 401 Unauthorized)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::warning('Guzzle ClientException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);

            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (ServerException $e) {
            // Handle 5xx server errors (e.g., 500 Internal Server Error)
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $responseBody = $response->getBody()->getContents();
            Log::error('Guzzle ServerException (' . $statusCode . '): ' . $responseBody);
            $responseBody = json_decode($responseBody, true);
            return [
                'success' => false,
                'message' => $responseBody['message']
            ];
            // Optionally return an error response or rethrow a custom exception
        } catch (RequestException $e) {
            // Catch-all for other Guzzle request-related exceptions
            Log::error('Guzzle RequestException: ' . $e->getMessage());
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
            // Optionally return an error response or rethrow a custom exception
        }
    }
}
