<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->web(append: [
            \App\Http\Middleware\SetDynamicLayout::class,
        ]);
        // CSRF Token
        $middleware->validateCsrfTokens(except: [
            'whatsapp/webhook',
            'mikrotik/webhook',
            'tripay/response',
        ]);
        $middleware->alias([
            'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission' => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
            'checkVersion' => \App\Http\Middleware\CheckVersion::class,
            'appIsntalled' => \App\Http\Middleware\CheckInstalled::class,
            'dynamic_layout' => \App\Http\Middleware\SetDynamicLayout::class,
            'PDFMerger' => Webklex\PDFMerger\Facades\PDFMergerFacade::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        $exceptions->render(function (\Spatie\Permission\Exceptions\UnauthorizedException $e, $request) {
           // if (Auth::user()->hasRole('admin')) {
                // return redirect()->route('dashboard');
                abort(401);
           // } else {
            //    return redirect()->route('customer.dashboard');
           // }
        });
    })->create();
