<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('qr_url')->nullable()->after('pay_code');
            $table->string('qr_string')->nullable()->after('pay_code');
            $table->string('pay_url')->nullable()->after('pay_code');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('qr_url');
            $table->dropColumn('qr_string');
            $table->dropColumn('pay_url');
        });

    }
};
