<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_histories', function (Blueprint $table) {
             $table->string('period')->nullable()->after('user_customer_id');
            $table->decimal('net_customer_price', 10, 2)->default(0)->after('user_customer_id');
            $table->string('paket_name')->nullable()->after('user_customer_id');
            $table->string('customer_address')->nullable()->after('user_customer_id');
            $table->string('customer_name')->nullable()->after('user_customer_id');
            $table->string('teller_name')->nullable()->after('transaction_id');
            $table->string('bank_account')->nullable()->after('payment_method');
            $table->dropColumn('paylater_date');
        });

        Schema::table('payments', function (Blueprint $table) {
             $table->string('refunded_bank_account')->nullable()->after('refunded_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_histories', function (Blueprint $table) {
            $table->dropColumn('bank_account');
            $table->dropColumn('teller_name');
            $table->timestamp('paylater_date')->nullable()->after('payment_method');
        });

         Schema::table('payments', function (Blueprint $table) {
             $table->dropColumn('refunded_bank_account');
        });
    }
};
