<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class CreatePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = collect([
            ['name' => 'invoices management'],
            ['name' => 'invoice payment'],
            ['name' => 'customers management'],
            ['name' => 'customer action'],
            ['name' => 'configurations management'],
            ['name' => 'pakets management'],
            ['name' => 'invoice action'],
            ['name' => 'paket action'],
            ['name' => 'roles management'],
            ['name' => 'role action'],
            ['name' => 'permissions management'],
            ['name' => 'permission action'],
            ['name' => 'mikrotiks management'],
            ['name' => 'mikrotik action'],
        ]);

        foreach ($permissions as $permission) {
            if (!Permission::whereName($permission['name'])->first()) {
                Permission::create([
                    'name' => $permission['name']
                ]);
            }
        }
    }
}
