@props(['invoice'])
<div class="flex gap-2 justify-end flex-col">
    <div class="flex justify-end">
        @if ($invoice->status != 'paid' && $invoice->periode === $invoice->customer_paket->invoices()->where('status', '!=','paid')->oldest()->first()->periode && $invoice->customer_paket->status != 'pending')
            <flux:tooltip content="{{ __('billing.button.pay') }}">
                <flux:button size="xs" wire:click="$dispatch('billing-payment-modal', {invoice: '{{ $invoice->id }}'})"
                    variant="primary" color="green" class="cursor-pointer" icon="check" :disabled="auth()->user()->can('invoice payment') || auth()->user()->hasRole('admin') ? false : true">
                    {{ __('billing.button.pay') }}
                </flux:button>
            </flux:tooltip>
        @endif
    </div>
    <div class="flex justify-end">
        <flux:button.group>
            @if ($invoice->payments->count())
                <flux:tooltip content="{{ __('View Detail') }}">
                    <flux:button size="xs" :href="route('billings.management.show-billing', $invoice->id)" wire:navigate :disabled="auth()->user()->can('invoice payment' || auth()->user()->hasRole('admin')) ? false : true"
                        variant="primary" color="amber" class="cursor-pointer" icon="document-text"/>
                </flux:tooltip>
            @endif
            @if ($invoice->status != 'paid')
                <flux:tooltip content="{{ __('billing.button.download-invoice') }}" position="bottom">
                    <flux:button size="xs" wire:click="download_customer_invoice('{{ $invoice->id }}')" :disabled="auth()->user()->can('invoice payment') || auth()->user()->hasRole('admin') ? false : true"
                        style="cursor: pointer;" variant="primary" icon="printer" />
                </flux:tooltip>


                <flux:tooltip content="{{ __('billing.button.add-discount') }}" position="bottom">
                    <flux:button size="xs" :disabled="auth()->user()->can('invoice payment') || auth()->user()->hasRole('admin') ? false : true"
                        wire:click="$dispatch('add-discount-modal', {invoice: '{{ $invoice->id }}'})"
                        style="cursor: pointer;" variant="primary" icon="plus-circle" />
                </flux:tooltip>

                @if (!$invoice->payments()->where('refund_status', 'partial')->count() && $invoice->status != 'paid' && $invoice->periode === $invoice->customer_paket->invoices()->where('status', '!=','paid')->latest('periode')->first()->periode)
                    <flux:tooltip content="{{ __('billing.button.delete-billing') }}" position="bottom">
                        <flux:button size="xs" :disabled="auth()->user()->can('invoice payment') || auth()->user()->hasRole('admin') ? false : true"
                            wire:click="$dispatch('show-delete-invoice-modal', {invoice: '{{ $invoice->id }}'})"
                            style="cursor: pointer;" variant="danger" icon="trash"/>
                    </flux:tooltip>
                @endif
            @else
                @if ($invoice->amount - $invoice->discount > 0)
                    <flux:button size="xs" :disabled="auth()->user()->can('invoice payment') ? false : true"
                        wire:click="$dispatch('download-billing-modal', {invoice: '{{ $invoice->id }}'})"
                        title=" {{ __('billing.button.receipt') }}" style="cursor: pointer;" variant="primary"
                        icon="printer" disabled />
                @endif
            @endif
        </flux:button.group>
    </div>
</div>

