@props(['invoice'])
<div class="space-y-1">
    <div class="flex gap-1">
        <flux:text class="text-xs">
            {{ trans('billing.label.amount') }} @moneyIDR($invoice->remaining_amount)
        </flux:text>

        @if ($invoice->total_refunded > 0)
            <flux:text class="text-violet-700 text-xs ms-1">R</flux:text>
        @endif
    </div>

    @if ($invoice->discount > 0)
    <div class="flex gap-1">
        <flux:text class="text-xs text-red-800 font-semibold">
            Discount: @moneyIDR($invoice->discount)
        </flux:text>
        <flux:button size="xs" variant="primary" color="rose" icon="minus-circle" class="ms-1" wire:click="$dispatch('sub-discount-modal', {invoice: '{{ $invoice->id }}'})" class="cursor-pointer"/>
    </div>
    @endif
    @if ($invoice->total_paid > 0)
    <div>
        <flux:text class="text-xs text-green-800 font-semibold">
            {{ trans('billing.label.payment_amount') }} @moneyIDR($invoice->total_paid)
        </flux:text>
    </div>
    @endif
</div>
