@props(['invoice'])

@if (!is_null($invoice->customer_paket->paylater_date))
<flux:tooltip content="{{ trans('Cancel') }}">
    <flux:badge wire:click="cancelPaylater('{{ $invoice->id }}')" size="sm" color="{{\Carbon\Carbon::now()->gte($invoice->customer_paket->paylater_date) ? 'red' : 'lime' }}" iconTrailing="x-circle" class="cursor-pointer">
        PL: {{ \Carbon\Carbon::parse($invoice->customer_paket->paylater_date)->format('d M y') }}
    </flux:badge>
</flux:tooltip>
@else
<div class="text-xs {{ $invoice->status == 'overdue'? 'text-red-500' : '' }}">
    {{ \Carbon\Carbon::parse($invoice->due_date)->format('d F Y') }}
</div>
@endif
