@props([
    'disabled' => false,
    'variant' => 'default',
    'label' => null,
    'name' => null

])

@if ($variant === 'floating')
    <div class="relative">
        @isset ($label)
            <label for="{{ $name }}" class="z-9 absolute text-sm {{ $errors->first($name) ? 'bg-red-500 text-white border-red-500' : 'bg-white' }} px-2 top-3.5 scale-75 -translate-y-5 left-1 transform rounded-full border">
                @if($errors->first($name))<flux:icon icon="exclamation-triangle" variant="mini" class="inline text-white" />@endif {{ $label }}
            </label>
        @endisset
        <div class="flex p-1">
            <select data-flux-select-native {{ $disabled ? 'disabled' : '' }}
            {!! $attributes->merge([
                'class' => 'bg-white dark:bg-white/10 dark:disabled:bg-white/[9%] w-full pl-3 pr-10 block h-10 py-2 text-base sm:text-sm leading-none rounded-lg appearance-none shadow-xs border text-gray-600',
            ]) !!}>
                {{ $slot }}
            </select>
        </div>
    </div>

@else
    <select data-flux-select-native {{ $disabled ? 'disabled' : '' }} {!! $attributes->merge([
        'class' =>
            'bg-white dark:bg-white/10 dark:disabled:bg-white/[9%] w-full pl-3 pr-10 block h-10 py-2 text-base sm:text-sm leading-none rounded-lg appearance-none shadow-xs border text-gray-600',
    ]) !!}>
        {{ $slot }}
    </select>
@endif



