@props(['customerPaket', 'user', 'size' => 'xs'])
<flux:button.group>
    <flux:tooltip :content="$customerPaket->paket->mikrotik->name ?? ''" position="bottom">
        <flux:button :size="$size" variant="primary" :color="$customerPaket->update_mikrotik_status === 'success' ? 'sky' : 'red'" :icon="$customerPaket->update_mikrotik_status === 'success' ? 'server' : 'exclamation-triangle'">
        {{ Str::limit($customerPaket->paket->mikrotik->name ?? '', 10)}}
        </flux:button>
    </flux:tooltip>
    @if ($customerPaket->status == 'pending' || $customerPaket->status == 'cancelled')
        @if ($customerPaket->internet_service->value == 'ppp')
            <flux:button :size="$size">
                {{ $customerPaket->internet_service->name }}
            </flux:button>
            <flux:tooltip :content="__('Activation')" position="bottom">
                <flux:button variant="danger" iconTrailing="check" :size="$size" style="cursor: pointer;"
                    wire:click="$dispatch('activation-customer-paket-modal',{customerPaket: '{{ $customerPaket->slug }}'})">
                    {{ \Illuminate\Support\Str::apa($customerPaket->status) }}
                </flux:button>
            </flux:tooltip>
        @endif
        @if ($customerPaket->internet_service->value == 'ip_static')
            @if (is_null($customerPaket->customer_static_paket->mac_address) ||
                    is_null($customerPaket->customer_static_paket->interface))
                @if (is_null($customerPaket->customer_static_paket->mac_address))
                    <flux:button :size="$size" title="Add MAC Address" style="cursor: pointer;"
                        wire:click="$dispatch('edit-mac-address-modal',{customerPaket: '{{ $customerPaket->slug }}'})">
                        <span class="text-red-500"> [Mac Address Required]</span>
                    </flux:button>
                @endif
                @if (is_null($customerPaket->customer_static_paket->interface))
                    <flux:button :size="$size" title="Update Interface" style="cursor: pointer;" wire:navigate
                        href="{{ route('customer.show', $user->username) }}">
                        <span class="text-red-500"> [Interface Required]</span>
                    </flux:button>
                @endif
            @else
                <flux:button :size="$size">
                    {{ $customerPaket->internet_service->name }}
                </flux:button>
                <flux:tooltip :content="__('Activation')" position="bottom">
                <flux:button variant="danger" iconTrailing="check" :size="$size" style="cursor: pointer;"
                    wire:click="$dispatch('activation-customer-paket-modal',{customerPaket: '{{ $customerPaket->slug }}'})">
                    {{ \Illuminate\Support\Str::apa($customerPaket->status) }}
                </flux:button>
                </flux:tooltip>
            @endif
        @endif
    @else
        <flux:tooltip :content="$customerPaket->status == 'active' ? 'Disable' : 'Enable'" position="bottom">
            <flux:button :size="$size" style="cursor: pointer;"
                wire:click="$dispatch('disable-customer-paket-modal',{customerPaket: '{{ $customerPaket->slug }}'})"
                icon="power" variant="primary" color="{{ $customerPaket->status === 'active' ? 'green' : 'red' }}">
                {{ \Illuminate\Support\Str::apa($customerPaket->status) }}
            </flux:button>
        </flux:tooltip>
        @if ($customerPaket->status == 'active')
            <flux:button :size="$size" :variant="$customerPaket->customer_installation_address->phone || $customerPaket->customer_billing_address->phone ? 'primary' : 'outline'" :color="$customerPaket->customer_installation_address->wa_notification && $customerPaket->customer_billing_address->wa_notification ? 'lime' : (!$customerPaket->customer_installation_address->wa_notification && !$customerPaket->customer_billing_address->wa_notification ? 'pink' : 'amber')" icon="wa" class="cursor-pointer px-2" wire:click="$dispatch('disable-wa-notification-installation-address-modal',{customerPaket: '{{ $customerPaket->slug }}'})"/>
            <flux:tooltip content="{{ $customerPaket->online ? 'Up' : 'Down' }}">
                <flux:button :size="$size"
                    icon="{{ $customerPaket->online ? 'arrow-up-circle' : 'arrow-down-circle' }}"
                    variant="primary" color="{{ $customerPaket->online ? 'green' : 'red' }}" />
            </flux:tooltip>
        @endif
    @endif
</flux:button.group>
