<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    @include('partials.head')
</head>
<body class="min-h-screen bg-white dark:bg-zinc-800">
    <flux:header container class="bg-zinc-50 dark:bg-zinc-900 border-b border-zinc-200 dark:border-zinc-700">
        <flux:sidebar.toggle class="lg:hidden" icon="bars-2" />

        <div class="max-lg:hidden">
            <x-app-logo/>
        </div>

        <flux:navbar class="-mb-px max-lg:hidden">
            <flux:navbar.item  wire:ignore icon="home" :href="route('dashboard')" :current="request()->routeIs('dashboard')" class="cursor-pointer" wire:navigate>
                {{ trans('menu.dashboard') }}
            </flux:navbar.item>

            @if(auth()->user()->hasRole('admin') || auth()->user()->can('customers management'))
                <flux:dropdown class="max-lg:hidden">
                    <flux:navbar.item wire:ignore :icon="request()->routeIs('customers.paket.management') ? 'chart-bar-square' : 'users'" icon-trailing="chevron-down" :current="request()->routeIs('customers.*')" class="cursor-pointer">
                        {{ request()->routeIs('customers.paket.management') ? trans('menu.customers-paket') : trans('menu.customers') }}
                    </flux:navbar.item>
                    <flux:menu>
                        <flux:menu.item wire:ignore icon="users" :href="route('customers.management')" :variant="request()->routeIs('customers.management')? 'zinc' : 'default'"
                            :current="request()->routeIs('customers.management')" wire:navigate>
                            {{ trans('menu.customers') }}
                        </flux:menu.item>
                        <flux:menu.item wire:ignore icon="chart-bar-square" :href="route('customers.paket.management')" :variant="request()->routeIs('customers.paket.management')? 'zinc' : 'default'"
                            :current="request()->routeIs('customers.paket.management')" wire:navigate>
                            {{ trans('menu.customers-paket') }}
                        </flux:menu.item>
                    </flux:menu>
                </flux:dropdown>
            @endif


            @if(auth()->user()->hasRole('admin') || auth()->user()->can('invoices management'))
                <flux:dropdown class="max-lg:hidden">
                    <flux:navbar.item wire:ignore :icon="request()->routeIs('billings.management.payments') ? 'credit-card' : 'currency-dollar'" icon-trailing="chevron-down" :current="request()->routeIs('billings.*')"  class="cursor-pointer">
                        {{ request()->routeIs('billings.management.payments') ? trans('menu.payment-histories') : trans('menu.billings') }}
                    </flux:navbar.item>

                    <flux:menu>
                        <flux:menu.item wire:ignore icon="currency-dollar" :href="route('billings.management')" :variant="request()->routeIs('billings.management')? 'zinc' : 'default'"
                            :current="request()->routeIs('billings.management')" wire:navigate>
                                {{ trans('menu.billings') }}
                        </flux:menu.item>
                        <flux:menu.item wire:ignore icon="credit-card" :href="route('billings.management.payments')" :variant="request()->routeIs('billings.management.payments')? 'zinc' : 'default'"
                            :current="request()->routeIs('billings.management.payments')" wire:navigate>
                            {{ trans('menu.payment-histories') }}
                        </flux:menu.item>
                    </flux:menu>
                </flux:dropdown>
            @endif

            @if(auth()->user()->hasRole('admin') || auth()->user()->can('pakets management'))
                <flux:navbar.item wire:ignore icon="layout-grid" :href="route('pakets.management')"
                    :current="request()->routeIs('pakets.management')" wire:navigate>
                    {{ trans('menu.pakets') }}
                </flux:navbar.item>
            @endif

            @if(auth()->user()->hasRole('admin') || auth()->user()->can('configurations management'))
            <flux:separator vertical variant="subtle" class="my-2"/>

            <flux:dropdown wire:ignore class="max-lg:hidden">
                <flux:navbar.item :icon="request()->routeIs('managements.hotspots') ? 'wifi' :(request()->routeIs('managements.whatsapp_gateway') ? 'wa' : 'cog')" icon-trailing="chevron-down" :current="request()->routeIs('managements.*')" class="cursor-pointer">
                    {{ request()->routeIs('managements.hotspots') ? trans('menu.hotspots') : (request()->routeIs('managements.whatsapp_gateway') ? trans('menu.whatsapp-gateway') : (request()->routeIs('managements.websystem') ? trans('menu.general') : trans('menu.settings') )) }}
                </flux:navbar.item>

                <flux:menu>
                    <flux:menu.item icon="cog" :href="route('managements.websystem')" :variant="request()->routeIs('managements.websystem')? 'zinc' : 'default'"
                        :current="request()->routeIs('managements.websystem')" wire:navigate class="cursor-pointer">
                        {{ trans('menu.general') }}
                    </flux:menu.item>

                    <flux:menu.separator />

                    <flux:menu.item wire:ignore icon="user-group" :href="route('managements.users')" :variant="request()->routeIs('managements.users')? 'zinc' : 'default'" wire:navigate>
                        {{trans('menu.users')}}
                    </flux:menu.item>

                    <flux:menu.separator />

                    <flux:menu.item wire:ignore icon="shield-check" :href="route('managements.roles')" :variant="request()->routeIs('managements.users')? 'zinc' : 'default'" wire:navigate>
                        {{trans('menu.roles')}}
                    </flux:menu.item>
                    <flux:menu.separator />
                    <flux:menu.submenu heading="{{ trans('menu.settings') }}">

                        <flux:menu.item :href="route('managements.hotspots')" :checked="request()->routeIs('managements.hotspots')" wire:navigate class="cursor-pointer">
                            {{ trans('menu.hotspots') }}
                        </flux:menu.item>
                        <flux:menu.item :href="route('managements.mikrotiks')" :checked="request()->routeIs('managements.mikrotiks')" wire:navigate class="cursor-pointer">
                            {{trans('menu.servers')}}
                        </flux:menu.item>
                        <flux:menu.item :href="route('managements.whatsapp_gateway')" :checked="request()->routeIs('managements.whatsapp_gateway')" wire:navigate class="cursor-pointer">
                            {{ trans('menu.whatsapp-gateway') }}
                        </flux:menu.item>
                    </flux:menu.submenu>
                </flux:menu>
            </flux:dropdown>
            @endif
        </flux:navbar>

        <flux:spacer />

        <flux:navbar class="me-4">
            <flux:tooltip :content="__('Donate')" position="bottom">
                <flux:navbar.item label="Donate" class="cursor-pointer" icon="currency-dollar"
                href="https://www.nihbuatjajan.com/griyanet" target="_blank"/>
            </flux:tooltip>

            <flux:tooltip :content="__('Documentation')" position="bottom">
                <flux:navbar.item class="cursor-pointer" icon="book-open-text"
                    href="{{ route('helps.home') }}" target="_blank" label="Documentation" :current="request()->routeIs('helps.*')"/>
            </flux:tooltip>
            <flux:navbar.item x-data x-on:click="$flux.dark = ! $flux.dark" icon="moon" class="cursor-pointer" iconVariant="solid" aria-label="Toggle dark mode"/>
        </flux:navbar>

        <flux:dropdown position="top" align="end">
            <flux:profile class="cursor-pointer" :initials="auth()->user()->initials()" />

            <flux:menu>
                <flux:menu.radio.group>
                    <div class="px-1 py-1.5">
                        <flux:profile :chevron="false" class="cursor-pointer" :initials="auth()->user()->initials()" :name="auth()->user()->first_name" />
                    </div>
                </flux:menu.radio.group>
                <flux:menu.separator />

                <flux:menu.radio.group>
                    <flux:menu.item href="/settings/profile" icon="cog" wire:navigate>{{ __('Settings') }}
                    </flux:menu.item>
                </flux:menu.radio.group>
                <flux:menu.separator />
                <form method="POST" action="{{ route('logout') }}" class="w-full">
                    @csrf
                    <flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full cursor-pointer">
                        {{ __('Log Out') }}
                    </flux:menu.item>
                </form>
            </flux:menu>
        </flux:dropdown>
    </flux:header>

    <flux:sidebar sticky collapsible="mobile" class="lg:hidden bg-zinc-50 dark:bg-zinc-900 border-r border-zinc-200 dark:border-zinc-700">
        <flux:sidebar.header>
            <x-app-logo/>

            <flux:sidebar.collapse class="in-data-flux-sidebar-on-desktop:not-in-data-flux-sidebar-collapsed-desktop:-mr-2" />
        </flux:sidebar.header>

        <flux:sidebar.nav>
            <flux:sidebar.item wire:ignore icon="home" :href="route('dashboard')" :current="request()->routeIs('dashboard')" wire:navigate>
                {{ __('Dashboard') }}
            </flux:sidebar.item>
             @if (request()->routeIs('managements.*'))
                <flux:sidebar.group expandable :heading="__('menu.settings')" class="grid" icon="cog" :expanded="false" :current="request()->routeIs('managements.*')">
                    <flux:sidebar.item wire:ignore icon="cog" :href="route('managements.websystem')" :current="request()->routeIs('managements.websystem')" wire:navigate>
                        {{trans('menu.general')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="user-group" :href="route('managements.users')" :current="request()->routeIs('managements.users')" wire:navigate>
                        {{trans('menu.users')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="shield-check" :href="route('managements.roles')" :current="request()->routeIs('managements.roles')" wire:navigate>
                        {{trans('menu.roles')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="server" :href="route('managements.mikrotiks')" :current="request()->routeIs('managements.mikrotiks')" wire:navigate>
                        {{trans('menu.servers')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="lock-closed" :href="route('managements.autoisolirs')" :current="request()->routeIs('managements.autoisolirs')" wire:navigate>
                        {{trans('menu.autoisolirs')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="server" :href="route('managements.wanMonitorings')" :current="request()->routeIs('managements.wanMonitorings')" wire:navigate>
                        {{trans('menu.wan-monitorings')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="rocket-launch" :href="route('managements.webhookMonitorings')" :current="request()->routeIs('managements.webhookMonitorings')" wire:navigate>
                        {{trans('menu.webhook-monitorings')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="building-library" :href="route('managements.banks')" :current="request()->routeIs('managements.banks')" wire:navigate>
                        {{trans('menu.banks')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="wa" :href="route('managements.whatsapp_gateway')" :current="request()->routeIs('managements.whatsapp_gateway')" wire:navigate>
                        {{ __('menu.whatsapp-gateway') }}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="building-library" :href="route('managements.paymentgateways')" :current="request()->routeIs('managements.paymentgateways')" wire:navigate>
                        {{trans('menu.payment-gateways')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore icon="book-open-text" :href="route('managements.address.list')" :current="request()->routeIs('managements.address.*')" wire:navigate>
                        Address
                    </flux:sidebar.item>
                </flux:sidebar.group>
            @else
                <flux:sidebar.group expandable :heading="__('menu.customers')" class="grid" icon="users" :expanded="request()->routeIs('customers.*')">
                    <flux:sidebar.item wire:ignore :href="route('customers.management')" :current="request()->routeIs('customers.management')" wire:navigate>
                        {{trans('menu.customers')}}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore :href="route('customers.paket.management')" :current="request()->routeIs('customers.paket.management')" wire:navigate>
                        {{ trans('menu.customers-paket') }}
                    </flux:sidebar.item>
                </flux:sidebar.group>

                <flux:sidebar.group expandable :heading="__('menu.billings')" class="grid" icon="currency-dollar" :expanded="request()->routeIs('billings.*')">
                    <flux:sidebar.item wire:ignore :href="route('billings.management')" wire:navigate icon="currency-dollar">
                        {{ trans('menu.billings') }}
                    </flux:sidebar.item>
                    <flux:sidebar.item wire:ignore :href="route('billings.management.payments')" wire:navigate icon="credit-card">
                        {{ trans('menu.payments') }}
                    </flux:sidebar.item>
                </flux:sidebar.group>

                <flux:sidebar.item wire:ignore icon="device-tablet" :href="route('pakets.management')" :current="request()->routeIs('pakets.management')" wire:navigate>
                    {{ __('menu.pakets') }}
                </flux:sidebar.item>
            @endif

        </flux:sidebar.nav>

        <flux:sidebar.spacer />

        <flux:sidebar.nav>
            @if (!request()->routeIs('managements.*'))
                <flux:sidebar.item icon="cog-6-tooth" :href="route('managements.websystem')" :current="request()->routeIs('managements.*')" wire:ignore wire:navigate>{{ __('menu.settings') }}</flux:sidebar.item>
            @endif
            <flux:sidebar.item icon="book-open-text" :href="route('helps.home')" target="_blank">Help</flux:sidebar.item>
        </flux:sidebar.nav>
    </flux:sidebar>

    {{ $slot }}

    @include('partials.footer')
</body>
</html>
