<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    @include('partials.head')
</head>
<body class="min-h-screen bg-white dark:bg-zinc-800">

    <!-- Desktop Menu -->
    <flux:header container class="bg-zinc-50 dark:bg-zinc-900 border-b border-zinc-200 dark:border-zinc-700">
        <flux:sidebar.toggle class="lg:hidden" icon="bars-2" inset="left" />

        <div class="max-lg:hidden">
            <x-app-logo/>
        </div>

        <flux:navbar class="-mb-px max-lg:hidden">
            <flux:navbar.item wire:ignore icon="home" :href="route('customer.dashboard')"
                :current="request()->routeIs('customer.dashboard')" wire:navigate>
                {{ trans('menu.customer.home') }}
            </flux:navbar.item>
            <flux:navbar.item icon="cursor-arrow-ripple" wire:ignore :href="route('customer.subscriptionmanagement')"
                :current="request()->routeIs('customer.subscriptionmanagement')" wire:navigate>
                {{ trans('menu.customer.subscription') }}
            </flux:navbar.item>
            <flux:navbar.item icon="newspaper" wire:ignore :href="route('customer.paymentmanagement')"
                :current="request()->routeIs('customer.paymentmanagement')" wire:navigate>
                {{ trans('menu.customer.bill') }}
            </flux:navbar.item>
        </flux:navbar>
        <flux:spacer />

        <flux:navbar class="me-4">
            <flux:navbar.item as="button" x-data x-on:click="$flux.dark = ! $flux.dark" icon="moon" class="cursor-pointer" iconVariant="solid" aria-label="Toggle dark mode"/>
        </flux:navbar>

        <flux:dropdown position="top" align="end">
            <flux:profile class="cursor-pointer" :initials="auth()->user()->initials()" />

            <flux:menu>
                <flux:menu.radio.group>
                    <div class="px-1 py-1.5">
                        <flux:profile :chevron="false" class="cursor-pointer" :initials="auth()->user()->initials()" :name="auth()->user()->first_name" />
                    </div>
                </flux:menu.radio.group>
                <flux:menu.separator />
                <flux:menu.radio.group>
                    <flux:menu.item href="/settings/profile" icon="cog" wire:navigate>{{ __('Settings') }}
                    </flux:menu.item>
                </flux:menu.radio.group>
                <flux:menu.separator />
                <form method="POST" action="{{ route('logout') }}" class="w-full">
                    @csrf
                    <flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full cursor-pointer">
                        {{ __('Log Out') }}
                    </flux:menu.item>
                </form>
            </flux:menu>
        </flux:dropdown>
    </flux:header>

    <!-- Mobile Menu -->
    <flux:sidebar sticky collapsible="mobile" class="lg:hidden bg-zinc-50 dark:bg-zinc-900 border-r border-zinc-200 dark:border-zinc-700">
        <flux:sidebar.header>
            <x-app-logo/>
            <flux:sidebar.collapse class="in-data-flux-sidebar-on-desktop:not-in-data-flux-sidebar-collapsed-desktop:-mr-2" />
        </flux:sidebar.header>

        <flux:sidebar.nav>
            <flux:sidebar.item wire:ignore icon="home" :href="route('customer.dashboard')" :current="request()->routeIs('customer.dashboard')" wire:navigate>{{trans('menu.customer.home')}}</flux:sidebar.item>
            <flux:sidebar.item icon="cursor-arrow-ripple" wire:ignore :href="route('customer.subscriptionmanagement')" :current="request()->routeIs('customer.subscriptionmanagement')" wire:navigate>{{trans('menu.customer.subscription')}}</flux:sidebar.item>
            <flux:sidebar.item icon="newspaper" wire:ignore :href="route('customer.paymentmanagement')" :current="request()->routeIs('customer.paymentmanagement')" wire:navigate>{{trans('menu.customer.bill')}}</flux:sidebar.item>
        </flux:sidebar.nav>

        <flux:sidebar.spacer />


    </flux:sidebar>

    {{ $slot }}

    @include('partials.footer')
</body>
</html>
