@props([
    'on'
])

<div
    x-data="{ shown: false, timeout: null, notificationMessage: 'Save' }"
    x-init="@this.on('{{ $on }}', (message) => { clearTimeout(timeout); shown = true; notificationMessage = message; timeout = setTimeout(() => { shown = false }, 2000); })"
    x-show.transition.out.opacity.duration.1500ms="shown"
    x-transition:leave.opacity.duration.1500ms
    style="display: none"
    {{ $attributes->merge(['class' => 'text-sm']) }}
>
    
    @if ($slot->isEmpty())
        <div x-text="notificationMessage"></div>
    @else
        {{$slot}}
    @endif
    
</div>
