<!DOCTYPE html>
<html lang="en">

<head>
    <title>{{ trans('billing.label.receipt-number', ['id' => $receipt->number]) }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

    <style type="text/css" media="screen">
        html {

            line-height: 1.15;
            margin: 0;
        }

        body {
            font-weight: 400;
            line-height: 1.5;
            color: #212529;
            text-align: left;
            background-color: #fff;
            font-size: 10px;
            margin: 36pt;
        }

        h4 {
            margin-top: 0;
            margin-bottom: 0.5rem;
        }

        p {
            margin-top: 0;
            margin-bottom: 1rem;
        }

        strong {
            font-weight: bolder;
        }

        img {
            vertical-align: middle;
            border-style: none;
        }

        table {
            border-collapse: collapse;
        }

        th {
            text-align: inherit;
        }

        h4,
        .h4 {
            margin-bottom: 0.5rem;
            font-weight: 500;
            line-height: 1.2;
        }

        h4,
        .h4 {
            font-size: 1.5rem;
        }

        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
        }

        .table th,
        .table td {
            padding: 0.75rem;
            vertical-align: top;
        }

        .table.table-items .tr-items {
            border-bottom: 1px solid #dee2e6;
        }

        .table.table-items .tr-head {
            border-bottom: 1px solid #a3a3a3;
        }

        .table.table-items td {
            border-bottom: 1px solid #dee2e6;
        }

        .table thead th {
            vertical-align: bottom;
            border-bottom: 2px solid #dee2e6;
        }

        .mt-5 {
            margin-top: 3rem !important;
        }

        .pr-0,
        .px-0 {
            padding-right: 0 !important;
        }

        .pl-0,
        .px-0 {
            padding-left: 0 !important;
        }

        .text-right {
            text-align: right !important;
        }

        .text-center {
            text-align: center !important;
        }

        .text-uppercase {
            text-transform: uppercase !important;
        }


        body,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        table,
        th,
        tr,
        td,
        p,
        div {
            line-height: 1.1;
        }

        .party-header {
            font-size: 1.5rem;
            font-weight: 400;
        }

        .total-amount {
            font-size: 12px;
            font-weight: 700;
        }

        .border-0 {
            border: none !important;
        }

        .cool-gray {
            color: #6B7280;
        }
    </style>
</head>

<body>
    {{-- Header --}}
    <img src="{{ public_path('images/receipt_logo.png') }}" alt="GriyaNet" width="200" />

    <table class="table mt-5">
        <tbody>
            <tr>
                <td class="border-0 pl-0" width="70%">
                    <h4 class="text-uppercase">
                        <strong>{{ trans('billing.label.receipt') }}</strong>
                    </h4>
                </td>
                <td class="border-0 pl-0">

                    <h4 class="text-uppercase cool-gray">
                        <strong>LUNAS</strong>
                    </h4>
                    <p>{{ __('invoice.serial') }} <strong>{{ $receipt->number }}</strong></p>

                    <p>{{ __('invoice.date') }}:
                        <strong>{{ \Carbon\Carbon::parse($billing->created_at)->format('d F Y') }}</strong>
                    </p>
                </td>
            </tr>
        </tbody>
    </table>

    {{-- Seller - Buyer --}}
    <table class="table">
        <thead>
            <tr>
                <th class="border-0 pl-0 party-header" width="48.5%">
                    {{ __('invoice.seller') }}
                </th>
                <th class="border-0" width="3%"></th>
                <th class="border-0 pl-0 party-header">
                    {{ __('invoice.buyer') }}
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="px-0">
                    @if ($system->title)
                        <p class="seller-name">
                            <strong>{{ $system->title }}</strong>
                        </p>
                    @endif

                    @if ($system->address)
                        <p class="seller-address">
                            {{ __('invoice.address') }}: {{ $system->address }}
                        </p>
                    @endif


                    <p class="seller-code">
                        {{ __('invoice.code') }}: 12345
                    </p>



                    <p class="seller-vat">
                        {{ __('invoice.vat') }}: Vat Code
                    </p>


                    @if ($system->phone)
                        <p class="seller-phone">
                            {{ __('invoice.phone') }}: {{ $system->phone }}
                        </p>
                    @endif

                </td>
                <td class="border-0"></td>
                <td class="px-0">
                    @if ($receipt->customer_name)
                        <p class="buyer-name">
                            <strong>{{ $receipt->customer_name }}</strong>
                        </p>
                    @endif

                    @if ($receipt->customer_address)
                        <p class="buyer-address">
                            {{ __('invoice.address') }}: {{ $receipt->customer_address }}
                        </p>
                    @endif

                    @if ($receipt->customer_id)
                        <p class="buyer-code">
                            {{ __('invoice.code') }}: {{ $receipt->customer_id }}
                        </p>
                    @endif


                </td>
            </tr>
        </tbody>
    </table>

    {{-- Table --}}
    <table class="table table-items">
        <thead>
            <tr class="tr-head">
                <th scope="col" class="border-0 pl-0">{{ __('billing.table.no') }}</th>
                <th scope="col" class="border-0 pl-0">{{ __('invoice.description') }}</th>
                <th scope="col" class="text-right border-0">{{ __('invoice.price') }}</th>
                @if ($receipt->special_discount > 0)
                    <th scope="col" class="text-right border-0">{{ __('invoice.discount') }}</th>
                @endif
                <th scope="col" class="text-right border-0 pr-0">{{ __('invoice.sub_total') }}</th>

            </tr>
        </thead>
        <tbody>
            {{-- Items --}}
            <tr class="tr-items">
                <td class="text-center">1</td>
                <td class="pl-0">
                    {{ $receipt->paket_name }} -
                    {{ \Carbon\Carbon::parse($receipt->periode)->format('F Y') }}
                </td>

                <td class="text-right">
                    @moneyIDR($receipt->paket_price)
                </td>
                @if ($receipt->special_discount > 0)
                    <td class="text-right">
                        @moneyIDR($receipt->special_discount)
                    </td>
                @endif
                <td class="text-right pr-0">
                    @moneyIDR($receipt->paket_price - $receipt->special_discount)
                </td>
            </tr>

            {{-- Summary --}}

            <tr>
                <td colspan="@if ($receipt->special_discount > 0) 3 @else 2 @endif" class="border-0"></td>
                <td class="text-right pl-0">{{ __('invoice.sub_total') }}</td>
                <td class="text-right pr-0">

                    @moneyIDR($receipt->paket_price - $receipt->special_discount)
                </td>
            </tr>
            @if ($system->tax_rate > 0)
                <tr>
                    <td colspan="@if ($receipt->special_discount > 0) 3 @else 2 @endif" class="border-0"></td>
                    <td class="text-right pl-0">{{ __('invoice.tax_rate') }}</td>
                    <td class="text-right pr-0">
                        {{ $receipt->tax_rate }} %
                    </td>
                </tr>
            @endif

            @if ($system->tax_rate > 0)
                <tr>
                    <td colspan="@if ($receipt->special_discount > 0) 3 @else 2 @endif" class="border-0"></td>
                    <td class="text-right pl-0">{{ __('invoice.total_taxes') }}</td>
                    <td class="text-right pr-0">
                        @moneyIDR($receipt->tax)
                    </td>
                </tr>
            @endif


            <tr>
                <td colspan="@if ($receipt->special_discount > 0) 3 @else 2 @endif" class="border-0"></td>
                <td class="text-right pl-0">{{ __('invoice.total_amount') }}</td>
                <td class="text-right pr-0 total-amount">
                    @moneyIDR($receipt->total_ammount)
                </td>
            </tr>
        </tbody>
    </table>


    <p>
        {{ __('invoice.notes') }}: note
    </p>

    <p>
        {{ __('invoice.amount_in_words') }}:
    </p>
    <p>
        {{ __('invoice.payment-time') }}: {{ \Carbon\Carbon::parse($receipt->created_at)->format('d F Y, H:i') }}
    </p>

    <script type="text/php">
            if (isset($pdf) && $PAGE_COUNT > 1) {
                $text = "{{ __('invoice.page') }} {PAGE_NUM} / {PAGE_COUNT}";
                $size = 10;
                $font = $fontMetrics->getFont("Verdana");
                $width = $fontMetrics->get_text_width($text, $font, $size) / 2;
                $x = ($pdf->get_width() - $width);
                $y = $pdf->get_height() - 35;
                $pdf->page_text($x, $y, $text, $font, $size);
            }
        </script>
</body>

</html>
