<div class="flex gap-2 flex-col">
     @php
       $whatsappGatewayDisabled = \App\Models\WhatsappGateway\WhatsappGatewayGeneral::first()->disabled;
       $paymentGateway = \App\Models\PaymentGateway::where('is_active', true)->first();
    @endphp
    <div class="relative mb-6 w-full">
        <div class="flex flex-col md:flex-row justify-between gap-2 mb-6">
            <div class="flex flex-col md:flex-row justify-start gap-2">
                <flux:heading size="xl" level="1">{{ __('Billing') }}</flux:heading>

            </div>
            <div class="flex flex-col md:flex-row justify-between">
                <!--Drop Down-->
                <flux:dropdown align="end">
                    <flux:button icon:trailing="chevron-down" class="cursor-pointer">Options</flux:button>
                    <flux:menu>
                        @if (!$whatsappGatewayDisabled)
                            <flux:menu.item icon="wa" wire:click="$dispatch('send-notification-modal')" class="cursor-pointer">{{ __('billing.button.send-notification') }}</flux:menu.item>
                            <flux:menu.separator />
                        @endif

                        <flux:menu.submenu icon="document-text" heading="Invoice">
                            <flux:menu.item wire:click="$dispatch('create-new-billings-modal')" class="cursor-pointer">
                                {!! trans('billing.button.create') !!}
                            </flux:menu.item>
                            <flux:menu.item wire:click="$dispatch('show-reset-next-bill-modal')" class="cursor-pointer">
                                {!! trans('billing.button.reset-next-bill') !!}
                            </flux:menu.item>
                        </flux:menu.submenu>

                        @if (count($invoices))
                            <flux:menu.submenu icon="printer" heading="Export">
                                <flux:menu.item wire:click="$dispatch('show-create-invoices-modal')" class="cursor-pointer">
                                    {!! trans('billing.button.invoice') !!}
                                </flux:menu.item>
                                <flux:menu.item wire:click="$dispatch('export-billing-modal')" class="cursor-pointer">
                                    {!! trans('billing.button.billing') !!}
                                </flux:menu.item>
                            </flux:menu.submenu>
                        @endif
                        <flux:menu.separator />
                        <flux:menu.item icon="cog-6-tooth" wire:click="$dispatch('billing-setting-modal')" class="cursor-pointer">{{ __('Setting') }}</flux:menu.item>
                    </flux:menu>
                </flux:dropdown>
             </div>
        </div>
        <flux:separator variant="subtle"/>
    </div>

    <!--Search Form-->
    <div class="space-y-4">
        @if ($paymentGateway && $paymentGateway->value === 'tripay' && env('TRIPAY_MODE') === 'development')
            <flux:callout variant="danger" icon="exclamation-triangle">
                <flux:callout.heading>Payment Gateway</flux:callout.heading>
                    <flux:callout.text>
                        The payment gateway is in developer mode, so don't conduct real transactions with customers. It's used solely for testing payments through the payment gateway.
                    </flux:callout.text>
            </flux:callout>
        @endif

        <div class="grid lg:grid-cols-6 gap-4">
            <flux:input wire:model.live.debounce.500ms="search_name" type="text"
                placeholder="{{ trans('billing.ph.search-with-name') }}" clearable/>
            <flux:input wire:model.live.debounce.500ms="search_address" type="text"
                placeholder="{{ trans('billing.ph.search-with-address') }}" clearable/>

            <flux:select wire:model.change="search_with_status">
                <flux:select.option value="pending">{{ trans('billing.status.unpayment') }}</flux:select.option>
                <flux:select.option value="paylater">{{ trans('billing.status.pay-later') }}</flux:select.option>
                <flux:select.option value="overdue">{{ trans('billing.status.overdue') }}</flux:select.option>
                <flux:select.option value="partially_paid">{{ trans('billing.status.partial-paid') }}</flux:select.option>
                <flux:select.option value="failed">Failed</flux:select.option>
                <flux:select.option value="paid">{{ trans('billing.status.payment') }}</flux:select.option>
                <flux:select.option value="">{{ trans('billing.ph.all') }}</flux:select.option>
            </flux:select>

            @if($search_with_status === 'paylater' || $search_with_status === 'partially_paid' || $search_with_status === 'paid')
            <flux:select wire:model.change="search_with_teller">
                <flux:select.option value="">{{ trans('billing.ph.search-teller') }}</flux:select.option>
                @foreach ($users as $user)
                    <flux:select.option value="{{ $user->full_name }}">
                        {{ $user->full_name }}
                    </flux:select.option>
                @endforeach
            </flux:select>
            @endif

            <flux:select wire:model.change="search_with_year">
                <flux:select.option value="all-year">{{ __('billing.ph.all-year') }}</flux:select.option>
                @foreach (array_reverse(\Carbon\CarbonPeriod::create(now()->subYears(5), '1 year', now())->toArray()) as $date)
                    <flux:select.option value="{{ $date->format('Y') }}">
                        {{ $date->format('Y') }}
                    </flux:select.option>
                @endforeach
            </flux:select>

            <flux:select wire:model.change="search_with_month" name="search_with_month">
                <flux:select.option value="all-month">{{ __('billing.ph.all-month') }}</flux:select.option>
                @foreach (array_reverse(\Carbon\CarbonPeriod::create(now()->addMonth(), '1 month', now()->addMonths(12))->toArray()) as $date)
                    <flux:select.option value="{{ $date->format('m') }}">
                        {{ $date->format('F') }}
                    </flux:select.option>
                @endforeach
            </flux:select>
        </div>

        <div class="grid lg:grid-cols-6 gap-4">

            <div class="col-span-2">
                <x-input-date-range>
                    <x-slot name="start_date" wire:model="startDateDeadline"></x-slot>
                    <x-slot name="end_date" wire:model="endDateDeadline"></x-slot>
                </x-input-date-range>
            </div>

            <flux:button size="sm" wire:click="clearSearch" title="{{ __('Reset') }}" style="cursor: pointer;"
                variant="primary" iconTrailing="x-circle">{{ __('Reset') }}
            </flux:button>

            <flux:modal.trigger name="advance-search">
                <flux:button iconTrailing="magnifying-glass-circle" size="sm" variant="primary" disabled
                    style="cursor: pointer;">
                    {{ __('Advance Search') }}
                </flux:button>
            </flux:modal.trigger>
        </div>
    </div>

    <div wire:loading.class="opacity-75">
    <flux:checkbox.group>
        <x-tables.table class="table-fixed">
            <x-slot name="header">
                <x-tables.theader>
                    <x-tables.header class="w-2 text-center">{{ trans('billing.table.no') }}</x-tables.header>
                    <x-tables.header class="w-max" sortable wire:click.prevent="sortBy('full_name')"
                        :direction="$sortField === 'full_name' ? $sortDirection : null">{{ trans('billing.table.customer-name') }}</x-tables.header>
                    <x-tables.header sortable wire:click.prevent="sortBy('full_address')"
                        :direction="$sortField === 'full_address' ? $sortDirection : null">
                        {{ trans('Billing Address') }}
                    </x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.customer-paket') }}
                    </x-tables.header>
                    <x-tables.header sortable wire:click.prevent="sortBy('periode')"
                        :direction="$sortField === 'periode' ? $sortDirection : null">
                        {{ trans('billing.table.periode') }}
                    </x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.bill') }}
                    </x-tables.header>
                    @if($search_with_status != 'paid')
                    <x-tables.header>
                        Status
                    </x-tables.header>
                    <x-tables.header sortable wire:click.prevent="sortBy('due_date')"
                        :direction="$sortField === 'due_date' ? $sortDirection : null">
                        {{ trans('billing.table.deadline') }}
                    </x-tables.header>
                    @endif

                    @if($search_with_status === 'paid')
                    <x-tables.header>
                        {{ trans('billing.table.payment-time') }}
                    </x-tables.header>
                    @endif

                    <x-tables.header>
                        {{ trans('Note') }}
                    </x-tables.header>

                    <x-tables.header>
                        {{ trans('billing.table.action') }}
                    </x-tables.header>
                </x-tables.theader>
            </x-slot>
            <x-slot name="body">
                @forelse ($invoices as $key => $invoice)
                    <x-tables.row>
                        <x-tables.cell class="text-center">
                            <flux:checkbox class="text-xs" wire:model.live="selectedInvoice" wire:key="{{ $invoice->id }}" value="{{ $invoice->id }}" :label="($invoices->currentpage() - 1) * $invoices->perpage() + $loop->index + 1"/>
                        </x-tables.cell>
                        <x-tables.cell>
                            <div class="space-y-2">
                                <div>
                                    <flux:link :href="route('customer.show', $invoice->user_username)" variant="ghost" class="font-semibold">{{ $invoice->full_name }}</flux:link>
                                </div>
                                @php
                                    $userInvoicesCount = $invoice->user->invoices()->where('invoices.status', '!=', 'paid')->count();
                                @endphp
                                @if ($userInvoicesCount > 1 && $invoice->periode === $invoice->customer_paket->invoices()->where('status', '!=','paid')->oldest()->first()->periode)
                                    <flux:button size="xs" variant="primary" icon="eye" color="yellow" :href="route('billings.customer.billing', $invoice->user_username)">
                                        {{ $userInvoicesCount }} invoices
                                    </flux:button>
                                @endif
                            </div>
                        </x-tables.cell>
                        @php
                            $installationAddress = $invoice->customer_paket->customer_installation_address;
                            $address = $installationAddress->address?$installationAddress->address.', ' : '';
                            $subdistrict = $installationAddress->subDistrict?$installationAddress->subDistrict.', ' : '';
                            $district = $installationAddress->district?$installationAddress->district.', ' : '';
                            $city = $installationAddress->city?$installationAddress->city.', ' : '';
                            $province = $installationAddress->province?$installationAddress->province.', ' : '';
                            $country = $installationAddress->country?$installationAddress->country.', ' : '';
                            $fullAddress = $address.$subdistrict.$district.$city.$province.$country;
                        @endphp
                        <x-tables.cell>
                             {{ $fullAddress }}
                        </x-tables.cell>
                        <x-tables.cell>
                            <flux:text class="text-xs">
                                {{ $invoice->customer_paket->paket->name.' - '.$invoice->customer_paket->internet_service->value }}
                            </flux:text>

                            <flux:text class="text-xs">
                                {{ Str::apa($invoice->customer_paket->renewal_period) }} - @moneyIDR($invoice->total_amount)
                            </flux:text>

                            @if (!is_null($invoice->customer_paket->customer_billing_address->last_reminder_date))
                                <flux:text class="text-xs text-green-800">
                                    Last Reminder {{ \Carbon\Carbon::parse($invoice->customer_paket->customer_billing_address->last_reminder_date)->format('d M Y, H:i') }}
                                </flux:text>
                            @endif

                            @if ($invoice->customer_paket->update_mikrotik_status === 'failed')
                                <flux:badge size="sm" variant="solid" color="red" icon="exclamation-triangle">
                                    Update Mikrotik Failed
                                </flux:badge>
                            @endif
                        </x-tables.cell>
                        <x-tables.cell align="center">
                            <flux:tooltip class="space-y-1" content="{{ \Carbon\Carbon::parse($invoice->start_periode)->format('d F Y').' - '. \Carbon\Carbon::parse($invoice->end_periode)->format('d F Y') }}">
                                    <flux:badge size="sm">
                                        {{ \Carbon\Carbon::parse($invoice->start_periode)->format('d M y') }}
                                    </flux:badge>
                                    <flux:badge size="sm">
                                        {{ \Carbon\Carbon::parse($invoice->end_periode)->format('d M y') }}
                                    </flux:badge>
                            </flux:tooltip>

                        </x-tables.cell>

                        <x-tables.cell>
                            <x-billings.bill-amount :invoice="$invoice" />

                        </x-tables.cell>

                        @if($search_with_status != 'paid')
                        <x-tables.cell align="center">
                            <div class="flex gap-1">
                                <flux:icon :icon="$invoice->status === 'pending' ? 'clock' : ($invoice->status === 'failed' ? 'exclamation-triangle': ($invoice->status === 'overdue' ? 'hand-thumb-down':'information-circle'))" class="{{ $invoice->status === 'failed' ? 'text-red-500': ($invoice->status === 'overdue' ? 'text-red-800':'') }}" variant="micro"/>
                                <div class="text-xs place-content-center {{ $invoice->status === 'failed' ? 'text-red-500 font-semibold' : '' }}">
                                    {{ Str::apa(Str::replace('_', ' ', $invoice->status)) }}
                                </div>
                            </div>
                        </x-tables.cell>
                        <x-tables.cell align="center">
                            <x-billings.deadline-bill :invoice="$invoice" />
                        </x-tables.cell>
                        @endif

                        @if($search_with_status === 'paid')
                        <x-tables.cell>
                            <x-billings.status-payment :invoice="$invoice" />
                        </x-tables.cell>
                        @endif

                        <x-tables.cell>
                            {{ $invoice->notes }}
                        </x-tables.cell>

                        <x-tables.cell>
                            <div class="flex justify-end">
                                @if($invoice->customer_paket->status === 'pending')
                                    <flux:tooltip :content="__('Activation')" position="bottom">
                                        <flux:button variant="danger" size="xs" style="cursor: pointer;"
                                            wire:click="$dispatch('activation-customer-paket-modal',{customerPaket: '{{ $invoice->customer_paket->slug }}'})">
                                            Activation
                                        </flux:button>
                                    </flux:tooltip>
                                @else
                                    <x-billings.bill-action :invoice="$invoice" />
                                @endif
                            </div>
                        </x-tables.cell>

                    </x-tables.row>
                @empty
                    <x-tables.row>
                        <x-tables.cell colspan=10>
                            <div class="flex justify-center items-center">
                                <span class="font-medium py-8 text-gray-400 text-xl">
                                    {{ trans('billing.notfound') }}
                                </span>
                            </div>
                        </x-tables.cell>
                    </x-tables.row>
                @endforelse

                @if ($invoices->count())
                 <x-tables.row>
                    <x-tables.cell colspan=2>
                        <flux:checkbox.all wire:model="checkAll" wire:key="{{ Illuminate\Pagination\LengthAwarePaginator::resolveCurrentPage() }}" label="Select All"/>

                    </x-tables.cell>

                    <x-tables.cell colspan=8>
                        <div class="flex pt-1 pb-1 gap-2">

                                @if (collect($selectedInvoice)->count())
                                    @if($search_with_status === 'paid')
                                        <flux:tooltip content="{!! trans_choice('billing.payment.tooltip-bulk-unpayment', collect($selectedInvoice)->count(), [
                                            'count' => collect($selectedInvoice)->count(),]) !!}">
                                            <flux:button size="xs" variant="primary" color="red" class="cursor-pointer" disabled>
                                                {!! trans_choice('billing.button.bulk-unpayment', collect($selectedInvoice)->count(), [
                                                'count' => collect($selectedInvoice)->count(),]) !!}
                                            </flux:button>
                                        </flux:tooltip>
                                    @else
                                        <flux:tooltip content="{!! trans_choice('billing.payment.tooltip-bulk-payment', collect($selectedInvoice)->count(), [
                                            'count' => collect($selectedInvoice)->count(),]) !!}">
                                            <flux:button size="xs" variant="primary" color="green" class="cursor-pointer"
                                                wire:click="bulkSelectedPayment">
                                                {!! trans_choice('billing.button.bulk-payment', collect($selectedInvoice)->count(), [
                                                'count' => collect($selectedInvoice)->count(),]) !!}
                                            </flux:button>
                                        </flux:tooltip>

                                        <flux:tooltip content="{!! trans_choice('billing.tooltip-bulk-delete', collect($selectedInvoice)->count(), [
                                            'count' => collect($selectedInvoice)->count(),]) !!}">
                                            <flux:button icon="trash" size="xs" variant="primary" color="red" class="cursor-pointer" wire:click="bulkDeleteSelected">
                                                {!! trans_choice('billing.button.bulk-delete-invoice', collect($selectedInvoice)->count(), [
                                                'count' => collect($selectedInvoice)->count(),]) !!}
                                            </flux:button>
                                        </flux:tooltip>
                                    @endif
                                @endif

                        </div>
                    </x-tables.cell>
                </x-tables.row>
                 @endif
            </x-slot>

        </x-tables.table>
    </flux:checkbox.group>
        @if ($invoices->hasPages())
            <div class="p-3">
                {{ $invoices->links() }}
            </div>
        @endif
    </div>
    <x-advance-search-billing modalName="advance-search" />

    <livewire:admin.billings.modal.add-discount />
    <livewire:admin.billings.modal.sub-discount />
    <livewire:admin.billings.modal.billing-payment />
    <livewire:admin.billings.modal.bulk-payment />

    <livewire:admin.billings.modal.create-invoices-modal />
    <livewire:admin.billings.modal.create-new-billings />
    <livewire:admin.billings.modal.send-notifications />
    <livewire:admin.billings.modal.delete-invoice />
    <livewire:admin.billings.modal.reset-next-bill/>
    <livewire:admin.billings.modal.bulk-delete-invoice />
    <livewire:admin.billings.modal.setting />

    <livewire:admin.customers.modal.customer-paket.activation-paket />
</div>
