<div>
    @if ($paymentModal)
        @php
            $paymentGateway = \App\Models\PaymentGateway::where('is_active', true)->first();
        @endphp
        <flux:modal class="md:w-120 w-[90%]" wire:model="paymentModal" :dismissible="false" @close="closeModal()">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('billing.payment.payment', ['paket' => $invoice->customer_paket->paket->name, 'customer' => $invoice->customer_paket->user->full_name]) }}
                    </flux:heading>
                    @if ($paymentGateway && $paymentGateway->value === 'tripay' && env('TRIPAY_MODE') === 'development')
                        <flux:callout variant="danger" icon="exclamation-triangle">
                            <flux:callout.heading>Payment Gateway</flux:callout.heading>
                                <flux:callout.text>
                                    The payment gateway is in developer mode, so don't conduct real transactions with customers. It's used solely for testing payments through the payment gateway.
                                </flux:callout.text>
                        </flux:callout>

                    @endif
                </div>

                @if ($errors->any())
                    <flux:callout variant="danger" icon="exclamation-triangle">
                        <flux:callout.heading>Error</flux:callout.heading>
                            <flux:callout.text>
                                <ol class="list-decimal text-xs">
                                    @foreach ($errors->all() as $error)
                                        <li>
                                            {{ $error }}
                                        </li>
                                    @endforeach
                                </ol>
                            </flux:callout.text>
                    </flux:callout>
                @endif

                <form wire:submit="payment" class="space-y-4">
                    <flux:field>
                        <flux:label>{!! trans('billing.label.payment-methode') !!}</flux:label>
                        <flux:select wire:model.live="input.selectedPaymentMethode" name="selectedPaymentMethode">
                            <flux:select.option value="">{{ trans('billing.ph.select-payment-methode') }}
                            </flux:select.option>
                            <flux:select.option value="cash">{{ trans('billing.ph.cash') }}</flux:select.option>
                            @if (count(\App\Models\Bank::where('disabled', false)->get()))
                                <flux:select.option value="bank_transfer">{{ trans('billing.ph.bank-transfer') }}</flux:select.option>
                            @endif

                            @if ($paymentGateway)
                                <flux:select.option value="{{ $paymentGateway->value }}">{{ $paymentGateway->name }}</flux:select.option>
                            @endif
                            <flux:select.option value="paylater">{{ trans('billing.ph.paylater') }}</flux:select.option>
                        </flux:select>
                        <flux:error name="selectedPaymentMethode"/>
                    </flux:field>

                    <div x-show="show" x-data="{ show: false }"
                        {{ '@' . 'select-methode-transfer' }}.window="show = event.detail.open">
                         <flux:field>
                            <flux:label>{!! trans('billing.label.bank') !!}</flux:label>
                            <flux:select wire:model.live="input.selectedBankTransfer" name="selectedBankTransfer">
                                <flux:select.option value="">{{ trans('billing.ph.select-bank') }}
                                </flux:select.option>
                                @foreach (\App\Models\Bank::where('disabled', false)->orderBy('bank_name', 'asc')->get() as $account_bank)
                                    <flux:select.option value="{{ $account_bank->slug }}">{{ $account_bank->bank_name }} -
                                        {{ $account_bank->account_name }}</flux:select.option>
                                @endforeach
                            </flux:select>
                            <flux:error name="selectedBankTransfer"/>
                        </flux:field>
                     </div>

                     <div x-show="show" x-data="{ show: false }"
                        {{ '@' . 'select-methode-tripay' }}.window="show = event.detail.open">

                            <flux:select wire:model.change="input.method" label="Method:">
                                <flux:select.option value="">{{ $order ? $order->payment_name : 'Select Method' }}</flux:select.option>
                                @foreach ($order ? collect($paymentChanels)->where('code', '!=', $order->payment_method) : collect($paymentChanels) as $paymentChanel)
                                    <flux:select.option value="{{ $paymentChanel['code'] }}">
                                        {{ $paymentChanel['name'] }} - {{ $paymentChanel['code'] }}
                                    </flux:select.option>
                                @endforeach
                            </flux:select>
                            <flux:error name="method" />
                     </div>

                    <div x-show="show" x-data="{ show: false }"
                        {{ '@' . 'input-amount' }}.window="show = event.detail.open">
                        <flux:input wire:model.live.debounce.500ms="input.amount" type="text" name="amount"
                        label="{{ trans('billing.label.amount') }}"/>
                    </div>
                    <div x-show="show" x-data="{ show: false }"
                        {{ '@' . 'select-paylater-date' }}.window="show = event.detail.open" class="w-full">

                        <flux:input wire:model="input.paylaterDate" type="date" name='paylaterDate'
                            label="{{ trans('billing.label.paylater') }}"
                            min="{{ $expiredDate->format('Y-m-d') }}"
                            max="{{ \Carbon\Carbon::parse($invoice->end_periode)->format('Y-m-d') }}" />
                    </div>

                     <div x-show="show" x-data="{ show: false }"
                        {{ '@' . 'input-customer-billing-phone' }}.window="show = event.detail.open">
                        <flux:input wire:model="input.customerPhone" type="text" name="customerPhone"
                        label="{{ trans('Customer Phone') }}"/>
                    </div>

                    @if ($order)
                        @if (!is_null($order['qr_url']))
                            <flux:label>Kode QR:</flux:label>
                            <div class="items-center justify-center flex">
                                <div class="items-center justify-center flex rounded-lg border-2 border-neutral-200 dark:border-neutral-700 size-50">
                                    <div class="p-2">
                                        <img src="{{ $order['qr_url'] }}"/>
                                    </div>
                                </div>
                            </div>
                        @elseif (!is_null($order['pay_url']))
                            <flux:label>Pay URL:</flux:label>
                            <flux:input value="{{$order['pay_url']}}" readonly copyable/>
                            <flux:callout variant="secondary" icon="information-circle" heading="Berikan pay url ini kepada pelanggan untuk melakukan pembayaran." />
                        @else
                            <flux:label>Kode Bayar:</flux:label>
                            <flux:input value="{{$order['pay_code']}}" readonly copyable/>
                        @endif

                    @endif

                    <flux:field variant="inline">
                        <flux:checkbox wire:model.live="input.send_notification" disabled/>
                            <flux:label>
                                {{ trans('Send WA Notification') }}
                            </flux:label>
                    </flux:field>

                    <flux:textarea wire:model="input.note" :label="__('billing.label.note')" type="text"
                        name="note" placeholder="{{ __('billing.ph.write-note') }}" />


                    <div class="flex items-center justify-end gap-2">
                        <flux:button wire:click="$set('paymentModal', false)" variant="ghost"  class="cursor-pointer">
                            {{ trans('billing.button.cancel') }}
                        </flux:button>

                        @if ($order)
                            <flux:button wire:click="changePaymentMethod" variant="primary" iconTrailing="arrow-right"  class="cursor-pointer">
                                {{ __('Change Payment Method') }}
                            </flux:button>
                        @else
                            <flux:button type="submit" variant="primary" iconTrailing="arrow-right"  class="cursor-pointer">
                                {{ __('billing.button.process') }}
                            </flux:button>
                        @endif
                    </div>

                </form>
            </div>
        </flux:modal>
    @endif
</div>
