<div>
    @if ($refundModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="refundModal" :dismissible="false">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('billing.payment.unpayment', ['paket' => $payment->invoice->customer_paket->paket->name, 'customer' => $payment->invoice->customer_paket->user->first_name]) }}
                    </flux:heading>

                    <flux:subheading>
                        {!! trans('billing.content.cancel-payment') !!}
                    </flux:subheading>
                </div>
                @if ($errors->any())
                    <flux:callout variant="danger" icon="exclamation-triangle">
                        <flux:callout.heading>Error</flux:callout.heading>
                            <flux:callout.text>
                                <ol class="list-decimal text-xs">
                                    @foreach ($errors->all() as $error)
                                        <li>
                                            {{ $error }}
                                        </li>
                                    @endforeach
                                </ol>
                            </flux:callout.text>
                    </flux:callout>
                @endif

                <form wire:submit="unpayment" class="space-y-4">
                    <div>
                    <flux:input wire:model="input.amount" type="text" autofocus :invalid="$errors->first('amount')"
                        :label="trans('billing.label.amount')"/>
                    </div>
                    <div>
                    <flux:textarea wire:model="input.note" :label="__('billing.label.note')" type="text" :invalid="$errors->first('note')"
                        autofocus autocomplete="note" placeholder="{{ __('billing.ph.write-note') }}" />
                    </div>
                    <div>
                    <flux:input wire:model="input.current_password" :label="__('user.label.confirm-password')" :invalid="$errors->first('current_password')"
                        type="password" placeholder="{{ __('Input your password') }}" />
                    </div>


                    <div class="flex items-center justify-end gap-2">

                        <flux:button wire:click="$set('refundModal', false)" variant="ghost"  class="cursor-pointer">
                            {{ trans('billing.button.cancel') }}
                        </flux:button>

                        <flux:button type="submit" variant="primary" iconTrailing="arrow-right"  class="cursor-pointer">
                            @if ($payment->invoice->status == 'paylater')
                                {{ __('billing.button.cancel-paylater') }}
                            @else
                                {{ __('billing.button.unpayment') }}
                            @endif
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
