<div>
    @if ($subDiscountModal)
    <flux:modal class="md:w-120 w-[90%]" wire:model="subDiscountModal" :dismissible="false">
        <div class="space-y-6">
            <div>
                <flux:heading size="lg">
                    Change discount invoice {{ $invoice->customer_paket->paket->name }} customer {{ $invoice->customer_paket->user->full_name }} periode {{ \Carbon\Carbon::parse($invoice->periode)->format('F Y') }}
                </flux:heading>
            </div>

            <form wire:submit="sub_discount" class="space-y-4">

                <flux:input wire:model="input.discount" label="Sub Discount" type="text"
                    name="discount" autofocus autocomplete="discount"
                    placeholder="Sub Discount" />

                <div class="flex items-center justify-end gap-2">
                    <flux:button wire:click="$set('subDiscountModal', false)" variant="ghost" class="cursor-pointer">
                        {{ trans('billing.button.cancel') }}
                    </flux:button>

                    <flux:button type="submit" variant="primary" iconTrailing="minus-circle" class="cursor-pointer">
                        Sub Discount
                    </flux:button>
                </div>
            </form>
        </div>
    </flux:modal>

    @endif
</div>
