<div>
    @php
        $userDeleted = App\Models\User::whereHas('user_customer', function ($user_customer) {
            $user_customer->onlyTrashed();
        })->onlyTrashed();
        $country_code = \App\Models\WhatsappGateway\WhatsappGatewayGeneral::first()->country_code;
    @endphp
    <div class="relative mb-6 w-full">
        <div class="flex flex-col md:flex-row justify-between gap-2 mb-6">
            <div class="flex flex-col md:flex-row justify-start gap-2">
                <div>
                    <h5 class="block font-sans text-xl antialiased font-semibold leading-snug tracking-normal text-blue-gray-900">
                        Customer list
                    </h5>
                    <p class="block mt-1 font-sans text-base antialiased font-normal leading-relaxed text-gray-700">
                        See information about all members
                    </p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row justify-between">
                <!--Drop Down-->
                <flux:dropdown align="end">
                    <flux:button icon:trailing="chevron-down" class="cursor-pointer">Options</flux:button>
                    <flux:menu>
                        <flux:menu.item icon="plus-circle" wire:click="$dispatch('add-customer-modal')" class="cursor-pointer">
                            {{ trans('customer.button.create') }}
                        </flux:menu.item>

                        <flux:menu.separator />

                        <flux:menu.item icon="printer" wire:click="exportUser" class="cursor-pointer" :disabled="true">
                            {{ __('user.button.export') }}
                        </flux:menu.item>

                        <flux:menu.separator />

                        <flux:menu.item :disabled="$userDeleted->count() ? false : true" variant="danger" icon="trash" :href="route('deletedCustomers.management')" wire:navigate>
                            {{ __('user.button.deleted-customers',['count'=>$userDeleted->count()]) }}
                        </flux:menu.item>

                        <flux:menu.separator />

                        <flux:menu.item icon="information-circle" class="cursor-pointer" :href="route('helps.customers.customer')" target="_blank">
                            {{ __('user.button.help') }}
                        </flux:menu.item>
                    </flux:menu>
                </flux:dropdown>
             </div>
        </div>
        <flux:separator variant="subtle"/>
    </div>


    <div class="flex flex-col md:flex-row justify-between gap-2 mb-6">
        <div class="flex flex-col md:flex-row justify-start gap-2">
            <div class="grid md:grid-cols-4 gap-2">
                <flux:input wire:model.live.debounce.500ms="search_name_or_email" type="text" clearable
                    icon="magnifying-glass" kbd="⌘K" placeholder="{{ trans('user.ph.search-with-name-email') }}"/>
                <flux:input wire:model.live.debounce.500ms="search_with_address" type="text" name="search_with_addres"
                    kbd="⌘K" clearable icon="magnifying-glass" placeholder="{{ trans('user.ph.search-with-address') }}"/>
                <flux:input wire:model.live.debounce.500ms="search_phone" type="text" name="search_phone"
                    kbd="⌘K" clearable icon="magnifying-glass" placeholder="{{ trans('Phone') }}"/>
            </div>
        </div>
        <div class="justify-between md:w-36">
            <flux:select wire:model.live="perPage">
                @foreach ($perPageOptions as $perPageOption)
                    <flux:select.option value="{{ $perPageOption }}">{{ $perPageOption }}</flux:select.option>
                @endforeach
            </flux:select>
        </div>
    </div>

    <div wire:loading.class="opacity-75" class="mt-2">
        <flux:checkbox.group wire:model.live="usersSelected">
            <x-tables.table>
                <x-slot name="header">
                    <x-tables.theader>
                        <x-tables.header sortable wire:click.prevent="sortBy('full_name')"
                            :direction="$sortField === 'full_name' ? $sortDirection : null">{{ trans('customer.table.name') }}</x-tables.header>
                        <x-tables.header sortable wire:click.prevent="sortBy('address')"
                            :direction="$sortField === 'address' ? $sortDirection : null">{{ trans('customer.table.address') }}
                        </x-tables.header>
                        <x-tables.header>{{ trans('customer.table.subscription') }}</x-tables.header>
                        <x-tables.header>{{ trans('customer.table.action') }}</x-tables.header>
                    </x-tables.theader>
                </x-slot>

                <x-slot name="body">
                    @forelse ($customers as $key => $user)
                        <x-tables.row>
                            <x-tables.cell class="p-4">
                                <div class="flex items-center gap-3">
                                    <flux:checkbox value="{{ $user->id }}" wire:key="{{ $user->username }}" wire:model.live="usersSelected"/>
                                    <flux:avatar-profile circle :chevron="false" :name="$user->full_name"/>

                                    <div class="flex flex-col">
                                        <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                                            <flux:link variant="ghost" wire:navigate :href="route('customer.show', $user->username)">{{ $user->full_name}}</flux:link>
                                            <flux:button size="xs" variant="ghost" icon="pencil" class="cursor-pointer"
                                                wire:click="$dispatch('edit-name-modal',{user: '{{ $user->username }}'})"/>
                                        </p>
                                        <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900 opacity-70">
                                            {{ $user->email}}
                                        </p>
                                    </div>
                                </div>
                            </x-tables.cell>
                            <x-tables.cell class="p-4 text-sm">
                                <div class="flex gap-1">
                                    <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                                    {{ $user->address }}

                                    <flux:button size="xs" variant="ghost" icon="pencil" class="cursor-pointer"
                                        wire:click="$dispatch('add-address-modal',{user: '{{ $user->username }}'})"/>
                                </p>
                                    </div>
                                @if ($user->phone)
                                    <div class="flex gap-1">
                                        <flux:icon.wa class="{{ $user->wa_notification ? 'text-green-800' : 'text-red-800' }} size-5 cursor-pointer" wire:click="$dispatch('disable-wa-notification-modal',{userAddress: '{{ $user->user_address_id }}'})"/>
                                        <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900 opacity-70 place-content-center">
                                            {{ preg_replace('/^' . $country_code . '?/', 0, $user->phone) }}
                                        </p>
                                        <flux:button size="xs" variant="ghost" icon="pencil" class="cursor-pointer"
                                        wire:click="$dispatch('add-phone-number-modal',{user: '{{ $user->username }}'})"/>

                                    </div>
                                @else
                                    <div class="opacity-70">
                                        <flux:icon.wa class="text-gray-400 size-5 cursor-pointer" wire:click="$dispatch('add-phone-number-modal',{user: '{{ $user->username }}'})"/>

                                    </div>
                                @endif
                            </x-tables.cell>
                            <x-tables.cell class="text-center p-4">
                                {!! trans_choice('customer.label.count-customer-paket', $user->customer_pakets->count(), ['count' => $user->customer_pakets->count()]) !!}
                            </x-tables.cell>

                            <x-tables.cell class="p-4">
                                <div class="flex gap-2 justify-end">
                                    <flux:button.group>
                                        @if (is_null($user->email_verified_at))
                                            <flux:button size="xs" title="Verification" style="cursor: pointer;"
                                                wire:click="verificationUser('{{ $user->username }}')">
                                                <flux:icon.check variant="micro" class="text-red-500" />
                                            </flux:button>
                                        @else
                                            @if (!$user->disabled)
                                                <flux:button size="xs" variant="primary" icon="plus-circle"
                                                    style="cursor: pointer;"
                                                    wire:click="$dispatch('add-customer-paket-modal',{user: '{{ $user->username }}'})"
                                                    title="{{ trans('customer.button.add-paket') }}" />
                                            @endif

                                            <flux:button size="xs" variant="primary"
                                                color="{{ $user->disabled ? 'red' : 'green' }}" icon="power"
                                                style="cursor: pointer;"
                                                wire:click="$dispatch('disable-customer-modal',{user: '{{ $user->username }}'})"
                                                title="{{ $user->disabled ? trans('customer.button.enable') : trans('customer.button.disable') }}" />

                                            @if ($user->invoices->where('status', '!=', 'paid')->count())
                                                <flux:tooltip
                                                    content="{{ $user->invoices->where('status', '!=', 'paid')->count() }} invoices">
                                                    <flux:button size="xs" variant="primary" color="green" icon="currency-dollar"
                                                        style="cursor: pointer;" wire:navigate
                                                        href="{{ route('billings.customer.billing', $user->username) }}" />
                                                </flux:tooltip>
                                            @endif

                                            <flux:button size="xs" variant="primary" icon="eye"
                                                style="cursor: pointer;" wire:navigate
                                                :href="route('customer.show', $user->username)"
                                                :title="trans('customer.button.show-customer')" />

                                            <flux:button size="xs" variant="primary" icon="pencil"
                                                style="cursor: pointer;"
                                                wire:click="$dispatch('edit-customer-modal',{user: '{{ $user->username }}'})"
                                                title="{{ trans('customer.button.edit-customer') }}" />

                                            <flux:button size="xs" variant="danger" icon="trash"
                                                style="cursor: pointer;"
                                                wire:click="$dispatch('delete-customer-modal',{user: '{{ $user->username }}'})"
                                                title="{{ trans('customer.button.delete-customer') }}" />
                                        @endif
                                    </flux:button.group>
                                </div>
                            </x-tables.cell>
                        </x-tables.row>

                    @empty
                        <x-tables.row>
                            <x-tables.cell colspan=6>
                                <div class="flex justify-center items-center">
                                    <span class="font-medium py-8 text-gray-400 text-xl">
                                        {{ trans('customer.notfound') }}
                                    </span>
                                </div>
                            </x-tables.cell>
                        </x-tables.row>
                    @endforelse
                    @if ($customers->count())
                    <x-tables.row>
                        <x-tables.cell>
                        </x-tables.cell>
                        <x-tables.cell colspan=5>
                            <div class="flex gap-2">
                                <flux:checkbox.all label="Select All" wire:model="selectAll" wire:key="{{ Illuminate\Pagination\LengthAwarePaginator::resolveCurrentPage() }}"/>

                                @if (collect($usersSelected)->count())
                                    <flux:button size="xs" variant="danger" icon="trash" style="cursor: pointer;"
                                        wire:click="bulkDelete" title="{{ trans('customer.button.delete-customer') }}">
                                        {{ trans('customer.button.bulk-delete-customer', ['count' => collect($usersSelected)->count()]) }}
                                    </flux:button>
                                        <flux:tooltip content="{{ trans('customer.helper.tooltip-bulk-edit-customer') }}">
                                    <flux:button size="xs" variant="primary" icon="pencil" style="cursor: pointer;"
                                        wire:click="bulkEdit">
                                        {{ trans('customer.button.bulk-edit-address', ['count' => collect($usersSelected)->count()]) }}
                                    </flux:button>
                                        </flux:tooltip>
                                @endif
                            </div>
                        </x-tables.cell>

                    </x-tables.row>
                    @endif

                </x-slot>
            </x-tables.table>
        </flux:checkbox.group>

        @if ($customers->hasPages())
            <div class="p-3">
                {{ $customers->links() }}
            </div>
        @endif
    </div>


    <livewire:admin.customers.modal.create-new-customer-modal />
    <livewire:admin.customers.modal.edit-customer-modal />
    <livewire:admin.customers.modal.bulk-edit-customer-modal />
    <livewire:admin.customers.modal.disable-customer />
    <livewire:admin.customers.modal.delete-customer />
    <livewire:admin.customers.modal.confirm-bulk-delete />
    <livewire:admin.customers.modal.disable-wa-notification />
    <livewire:admin.customers.modal.customer-paket.add-customer-paket-modal />
    <livewire:admin.customers.modal.add-phone-number />
    <livewire:admin.customers.modal.add-address />
    <livewire:admin.customers.modal.edit-name />

</div>
