<div>
    @if ($addAddressModal)
        <flux:modal wire:model="addAddressModal" class="md:w-120 w-[90%]" :dismissible="false" @close="closeModal()">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('Add Address') }}
                    </flux:heading>
                </div>
                @if ($errors->any())
                    <flux:callout variant="danger" icon="exclamation-triangle">
                        <flux:callout.heading>Error</flux:callout.heading>
                        <flux:callout.text>
                            <ol class="list-decimal text-xs">
                                @foreach ($errors->all() as $error)
                                    <li>
                                        {{ $error }}
                                    </li>
                                @endforeach
                            </ol>
                        </flux:callout.text>
                    </flux:callout>
                @endif
                <form wire:submit="editAddress" class="space-y-4">

                    <!--Country-->
                    <livewire:components.address-select.address-model-select
                        name="country"
                        :placeholder="trans('address.select-country')"
                        :value="request('country')"
                        :searchable="true"
                        iconLeading="magnifying-glass"
                        iconLeadingSelected="map-pin"
                        iconLeadingOption="map-pin"
                        iconVariantSelected="solid"
                        iconClassSelected="text-red-500 size-5"
                    />
                    <div class="grid md:grid-cols-2 gap-4">
                        <!--Province-->
                        <livewire:components.address-select.children-address-model-select
                            name="province"
                            children="country"
                            :searchable="true"
                            :placeholder="trans('address.select-province')"
                            :value="request('province')"
                            :depends-on="['country']"
                            :depends-on-values="['country' => request('country')]"
                            iconLeading="magnifying-glass"
                            iconLeadingSelected="check"
                            iconVariantSelected="solid"
                            iconClassSelected="text-green-500 size-5"
                        />
                        <!--City-->
                        <livewire:components.address-select.children-address-model-select
                            name="city"
                            children="province"
                            :searchable="true"
                            :placeholder="trans('address.select-city')"
                            :value="request('city')"
                            :depends-on="['province']"
                            :depends-on-values="['province' => request('province')]"
                            iconLeading="magnifying-glass"
                            iconLeadingSelected="check"
                            iconVariantSelected="solid"
                            iconClassSelected="text-green-500 size-5"
                        />
                    </div>
                    <div class="grid md:grid-cols-2 gap-4">
                        <!--District-->
                        <livewire:components.address-select.children-address-model-select
                            name="district"
                            children="city"
                            :searchable="true"
                            :placeholder="trans('address.select-district')"
                            :value="request('district')"
                            :depends-on="['city']"
                            :depends-on-values="['city' => request('city')]"
                            iconLeading="magnifying-glass"
                            iconLeadingSelected="check"
                            iconVariantSelected="solid"
                            iconClassSelected="text-green-500 size-5"
                        />
                        <!--Subdistrict-->
                        <livewire:components.address-select.children-address-model-select
                            name="subdistrict"
                            children="district"
                            :searchable="true"
                            :placeholder="trans('address.select-sub-district')"
                            :value="request('subdistrict')"
                            :depends-on="['district']"
                            :depends-on-values="['district' => request('district')]"
                            iconLeading="magnifying-glass"
                            iconLeadingSelected="check"
                            iconVariantSelected="solid"
                            iconClassSelected="text-green-500 size-5"
                        />
                    </div>

                    <!--Address -->
                    <flux:input wire:model="input.address" id="address" type="text" :invalid="$errors->first('address')" variant="floating" name="address" :label="__('user.label.address')"
                        autofocus autocomplete="address" placeholder="{{ __('customer.ph.address') }}" />

                        @if ($user->customer_pakets->count())
                            <!--update installation address -->
                            <flux:checkbox wire:model="updateInstallationAddress"
                                label="{{ trans('customer.label.add-installation-address') }}" />
                            <!--update billing address -->
                            <flux:checkbox wire:model="updateBillingAddress"
                                label="{{ trans('customer.label.add-billing-address') }}" />
                        @endif

                    <div class="flex items-center justify-end gap-2">
                        <flux:button wire:click="closeModal()" variant="ghost" class="cursor-pointer">
                            {{ __('Cancel') }}
                        </flux:button>
                        <flux:button type="submit" variant="primary" class="cursor-pointer">
                            {{ __('Save') }}
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
