<div>
    @if ($activationCustomerPaketModal)
        <flux:modal wire:model="activationCustomerPaketModal" class="md:w-120 w-[90%]">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('customer.paket.alert.header-activation-paket', [
                            'paket' => $customerPaket->paket->name,
                            'customer' => $customerPaket->user->first_name,
                        ]) }}
                    </flux:heading>
                </div>
                <form wire:submit='activation_paket'>
                    <div class="space-y-2">

                        @if ($customerPaket->mikrotik->auto_isolir->activation_date)
                            @php
                            if($isPrabayar){
                                $minDate = \Carbon\Carbon::now()->addDays($customerPaket->paket->trial_days)->format('Y-m-d');
                                $maxDate = \Carbon\Carbon::now()->addMonth()->addDays($customerPaket->paket->trial_days)->format('Y-m-d');
                            } else {
                                $maxDate = \Carbon\Carbon::now()->add($customerPaket->getRenewalPeriod())->addDays($customerPaket->paket->trial_days)->format('Y-m-d');
                                $minDate = \Carbon\Carbon::parse($maxDate)->subMonth()->format('Y-m-d');
                            }

                            @endphp
                            <div>
                                <flux:input wire:model.live.debounce.500ms="input.startPaymentDate" :label="__('Start payment')" type="date" :max="$maxDate" :min="$minDate"/>
                                <flux:error name='startPaymentDate'/>
                                <flux:text class="text-xs mt-1">First Payment on {{ \Carbon\Carbon::parse($input['startPaymentDate'])->format('d F Y') }} @if($customerPaket->paket->trial_days > 0) with {{ $customerPaket->paket->trial_days }} trial day @endif</flux:text>
                            </div>
                            @if ($customerPaket->status === 'pending' && $invoice)
                                <flux:checkbox wire:model.live="input.markAsPayment" label="Mark invoice as payment?" description="If checked, invoice mark as payment."/>

                                @if ($input['markAsPayment'])
                                <flux:separator variant="subtle" class="my-2" />
                                    <!--Start Payment Form-->

                                    <div>
                                        <flux:label>{!! trans('billing.label.payment-methode') !!}</flux:label>
                                        <flux:select wire:model.live="input.selectedPaymentMethode">
                                            <flux:select.option value="">{{ trans('billing.ph.select-payment-methode') }}
                                            </flux:select.option>
                                            <flux:select.option value="cash">{{ trans('billing.ph.cash') }}</flux:select.option>
                                            @if (count(\App\Models\Bank::where('disabled', false)->get()))
                                                <flux:select.option value="bank_transfer">{{ trans('billing.ph.bank-transfer') }}</flux:select.option>
                                            @endif
                                        </flux:select>
                                        <flux:error name="selectedPaymentMethode"/>
                                    </div>

                                    <div class="relative z-0" x-show="showBank" x-data="{ showBank: false }"
                                        {{ '@' . 'select-methode-transfer' }}.window="showBank = event.detail.open">
                                        <flux:field>
                                            <flux:label>{!! trans('billing.label.bank') !!}</flux:label>
                                            <flux:select wire:model.live="input.selectedBankTransfer" name="selectedBankTransfer">
                                                <flux:select.option value="">{{ trans('billing.ph.select-bank') }}
                                                </flux:select.option>
                                                @foreach (\App\Models\Bank::where('disabled', false)->orderBy('bank_name', 'asc')->get() as $account_bank)
                                                    <flux:select.option value="{{ $account_bank->slug }}">{{ $account_bank->bank_name }} -
                                                        {{ $account_bank->account_name }}</flux:select.option>
                                                @endforeach
                                            </flux:select>
                                            <flux:error name="selectedBankTransfer"/>
                                        </flux:field>
                                    </div>


                                    <flux:textarea wire:model="input.note" :label="__('billing.label.note')" type="text" disabled
                                        name="note" autofocus autocomplete="note" placeholder="{{ __('billing.ph.write-note') }}" />
                                    <!--End Payment Form-->
                                @endif
                            @endif
                        @else
                            <div>
                                <flux:select wire:model.change="input.startPaymentDate" :label="__('Start payment')">
                                    @foreach ($this->dates as $date)
                                    <flux:select.option value="{{ \Carbon\Carbon::parse($date)->format('Y-m-d') }}">
                                            {{ \Carbon\Carbon::parse($date)->format('d F Y') }}
                                        </flux:select.option>
                                    @endforeach
                                </flux:select>
                                <flux:error name='startPaymentDate'/>
                            </div>
                            <flux:text class="text-xs">First Payment on {{ \Carbon\Carbon::parse($input['startPaymentDate'])->format('d F Y') }}</flux:text>
                        @endif

                        <flux:separator variant="subtle" class="my-2" />

                        <div>
                            <flux:input wire:model="input.current_password" :label="__('user.label.confirm-password')"
                            type="password" placeholder="{{ __('Input your password') }}" />
                            <flux:error name="current_password"/>
                        </div>

                        <flux:separator variant="subtle" class="my-2" />
                        <div class="flex gap-2">
                            <flux:spacer />
                            <flux:button style="cursor: pointer;" variant="ghost" size="sm"
                                wire:click="$set('activationCustomerPaketModal', false)">
                                {{ trans('customer.button.cancel') }}
                            </flux:button>


                            <flux:button type="submit" variant="primary" icon="check" style="cursor: pointer;"
                                size="sm">
                                {{ trans('customer.paket.button.activation-paket') }}
                            </flux:button>
                        </div>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
