<div>
    @if ($addCustomerPaketModal)
        <flux:modal class="md:w-160 w-[90%]" wire:model="addCustomerPaketModal" :dismissible="false"
            @close="$dispatch('close-add-customer-modal')">
            <div class="space-y-6">
                <div>
                    @if ($currentStep === 1)
                        <flux:heading size="lg">
                            {{ trans('customer.paket.add-customer-paket', ['customer' => $user->full_name]) }}
                        </flux:heading>
                        <flux:subheading>
                            {{ trans('customer.paket.add-customer-paket', ['customer' => $user->full_name]) }}
                        </flux:subheading>
                    @elseif ($currentStep === 2)
                        <flux:heading size="lg">
                            {{ trans('customer.paket.add-installation-address', ['customer' => $user->full_name]) }}
                        </flux:heading>
                        <flux:subheading>
                            {{ trans('customer.paket.add-installation-address', ['customer' => $user->full_name]) }}
                        </flux:subheading>
                    @elseif ($currentStep === 3)
                        <flux:heading size="lg">
                            {{ trans('customer.paket.add-billing-address', ['customer' => $user->full_name]) }}
                        </flux:heading>
                        <flux:subheading>
                            {{ trans('customer.paket.add-billing-address', ['customer' => $user->full_name]) }}
                        </flux:subheading>
                    @endif
                </div>
                @if ($errors->any())
                <flux:callout variant="danger" icon="exclamation-triangle">
                    <flux:callout.heading>Error</flux:callout.heading>
                        <flux:callout.text>
                            <ol class="list-decimal text-xs">
                                @foreach ($errors->all() as $error)
                                    <li>
                                        {{ $error }}
                                    </li>
                                @endforeach
                            </ol>
                        </flux:callout.text>
                </flux:callout>
                @endif
                <form wire:submit="addCustomerPaket">
                    @if ($currentStep === 1)
                    <div class="flex flex-col gap-6">
                        <div class="grid auto-rows-min gap-4 md:grid-cols-2">
                            <div>
                                <flux:select wire:model.change="selectedServer" name="selectedServer" variant="floating"
                                    :label="__('customer.paket.label.server')">
                                    <flux:select.option value=""> {{ trans('customer.paket.ph.select-server') }}
                                    </flux:select.option>
                                    @foreach (\App\Models\Servers\Mikrotik::where('disabled', false)->orderBy('name', 'asc')->get() as $mikrotik)
                                        <flux:select.option value="{{ $mikrotik->id }}">
                                            {{ $mikrotik->name }}
                                        </flux:select.option>
                                    @endforeach
                                </flux:select>

                            </div>
                            <div>
                                <flux:select wire:model.change="input.selectedPaket" wire:key="{{ $selectedServer }}"  variant="floating"
                                    :label="__('customer.paket.ph.select-paket')" name="selectedPaket">
                                    <flux:select.option value=""> {{ trans('customer.paket.ph.select-paket') }}
                                    </flux:select.option>
                                    @if ($selectedServer)
                                        @foreach (\App\Models\Servers\Mikrotik::whereId($selectedServer)->first()->paketsOrderByPrice->where('disabled', false) as $paket)
                                            <flux:select.option value="{{ $paket->id }}">
                                                {{ $paket->name }} - @if ($paket->price == 0)
                                                    {{ trans('paket.free') }}
                                                @else
                                                    @moneyIDR($paket->price)
                                                @endif
                                            </flux:select.option>
                                        @endforeach
                                    @endif
                                </flux:select>
                            </div>
                        </div>

                        @if ($selectedPaket != '')
                            <div class="grid auto-rows-min gap-4 md:grid-cols-2">
                                <div>
                                    <flux:select wire:model.change="input.selectedInternetService"  variant="floating"
                                        :label="__('customer.paket.label.internet-service')"
                                        name="selectedInternetService">
                                        <flux:select.option value="">
                                            {{ trans('customer.paket.ph.select-service') }}
                                        </flux:select.option>
                                        @foreach ($internet_services as $internet_service)
                                            <flux:select.option value="{{ $internet_service->value }}">
                                                {{ $internet_service->name }}
                                            </flux:select.option>
                                        @endforeach
                                    </flux:select>
                                </div>
                                <div>
                                    @if ($selectedInternetService == 'ppp')
                                        <flux:select wire:model.change="input.selectedPppService"  variant="floating"
                                            :label="__('customer.paket.label.ppp-services')" name="selectedPppService">
                                            <flux:select.option value="">
                                                {{ trans('customer.paket.ph.select-ppp-service') }}
                                            </flux:select.option>
                                            @foreach ($ppp_services as $ppp_service)
                                                <flux:select.option value="{{ $ppp_service->id }}">
                                                    {{ $ppp_service->name }}
                                                </flux:select.option>
                                            @endforeach
                                        </flux:select>
                                    @elseif ($selectedInternetService == 'ip_static')
                                        <flux:select wire:model.change="input.selectedMikrotikInterface"  variant="floating"
                                            :label="__('customer.paket.label.interface')"
                                            name="selectedMikrotikInterface">
                                            <flux:select.option value="">
                                                {{ trans('customer.paket.ph.select-interface') }}
                                            </flux:select.option>
                                            @if ($mikrotik_interfaces)
                                                @foreach ($mikrotik_interfaces as $interface)
                                                    <flux:select.option value="{{ $interface['.id'] }}">
                                                        {{ $interface['name'] }}
                                                    </flux:select.option>
                                                @endforeach
                                            @endif
                                        </flux:select>
                                    @endif
                                </div>
                            </div>

                            <div class="grid auto-rows-min gap-4 md:grid-cols-2">

                                @if ($selectedInternetService == 'ip_static')
                                    <div>
                                        <flux:input wire:model="input.ip_address"  variant="floating"
                                            :label="__('customer.paket.label.ip-address')" type="text"
                                            name="ip_address" autofocus autocomplete="ip_address"
                                            placeholder="{{ __('customer.paket.label.ip-address') }}" />
                                    </div>
                                @endif
                            </div>
                            <div class="grid auto-rows-min gap-4 md:grid-cols-2">
                                <flux:select wire:model.change="input.renewal_period"  variant="floating"
                                        :label="__('customer.paket.ph.renewal-periode')" name="renewal_period">
                                    <flux:select.option value=""> {{ trans('customer.paket.ph.select-renewal-periode') }}</flux:select.option>
                                    <flux:select.option value="monthly">{{ trans('customer.paket.ph.monthly') }}</flux:select.option>
                                    <flux:select.option value="bimonthly">{{ trans('customer.paket.ph.bimonthly') }}</flux:select.option>
                                    <flux:select.option value="quarterly">{{ trans('customer.paket.ph.quarterly') }}</flux:select.option>
                                    <flux:select.option value="semi-annually">{{ trans('customer.paket.ph.semi-annually') }}</flux:select.option>
                                    <flux:select.option value="annually">{{ trans('customer.paket.ph.annually') }}</flux:select.option>
                                </flux:select>
                                @if ($selectedPaket->price > 0)
                                    <div>
                                        <flux:input wire:model="input.discount"  variant="floating"
                                            :label="__('customer.paket.label.discount')" type="text" name="discount"
                                            autofocus autocomplete="discount"
                                            placeholder="{{ __('customer.paket.label.discount') }}" />
                                    </div>
                                @endif
                            </div>
                        @endif

                        <div class="flex gap-2">
                            <flux:spacer />
                            <flux:button class="cursor-pointer" variant="ghost" wire:click="$set('addCustomerPaketModal', false)">
                                {{ trans('customer.button.cancel') }}
                            </flux:button>

                            <flux:button wire:click="addressInstallation" variant="primary" iconTrailing="arrow-right" class="cursor-pointer">
                                {{ __('Next') }}
                            </flux:button>

                        </div>
                    </div>

                    @elseif ($currentStep === 2)
                    <div class="flex flex-col gap-6">
                        <flux:checkbox wire:model.live="checkbox_installation_address" label="{{ trans('customer.label.add-installation-address') }}" />

                        @if ($checkbox_installation_address)
                            <!--Country-->
                            <livewire:components.address-select.address-model-select
                                name="country"
                                :placeholder="trans('address.select-country')"
                                :value="request('country')"
                                :searchable="true"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="map-pin"
                                iconLeadingOption="map-pin"
                                iconVariantSelected="solid"
                                iconClassSelected="text-red-500 size-5"
                            />
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Province-->
                                <livewire:components.address-select.children-address-model-select
                                    name="province"
                                    children="country"
                                    :searchable="true"
                                    :placeholder="trans('address.select-province')"
                                    :value="request('province')"
                                    :depends-on="['country']"
                                    :depends-on-values="['country' => request('country')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                                <!--City-->
                                <livewire:components.address-select.children-address-model-select
                                    name="city"
                                    children="province"
                                    :searchable="true"
                                    :placeholder="trans('address.select-city')"
                                    :value="request('city')"
                                    :depends-on="['province']"
                                    :depends-on-values="['province' => request('province')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                            </div>
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--District-->
                                <livewire:components.address-select.children-address-model-select
                                    name="district"
                                    children="city"
                                    :searchable="true"
                                    :placeholder="trans('address.select-district')"
                                    :value="request('district')"
                                    :depends-on="['city']"
                                    :depends-on-values="['city' => request('city')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                                <!--Subdistrict-->
                                <livewire:components.address-select.children-address-model-select
                                    name="subdistrict"
                                    children="district"
                                    :searchable="true"
                                    :placeholder="trans('address.select-sub-district')"
                                    :value="request('subdistrict')"
                                    :depends-on="['district']"
                                    :depends-on-values="['district' => request('district')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                            </div>
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Address -->
                                <flux:input wire:model="input.address" id="address" type="text" :invalid="$errors->first('address')" variant="floating" name="address" :label="__('user.label.address')"
                                    autofocus autocomplete="address" placeholder="{{ __('customer.ph.address') }}" />
                                <!--phone -->
                                <flux:input wire:model="input.phone" id="phone" type="text" :invalid="$errors->first('phone')" autofocus autocomplete="phone" variant="floating" name="phone" :label="__('user.label.phone')"
                                    placeholder="{{ __('customer.ph.phone') }}" />
                            </div>
                        @endif

                        <div class="flex gap-2">
                            <flux:spacer />
                            <flux:button wire:click="back(1)" variant="primary" icon="arrow-left" class="cursor-pointer">
                                {{ __('Back') }}
                            </flux:button>

                            <flux:button wire:click="addressBilling" variant="primary" iconTrailing="arrow-right" class="cursor-pointer">
                                {{ __('Next') }}
                            </flux:button>
                        </div>
                    </div>

                    @elseif ($currentStep === 3)
                    <div class="flex flex-col gap-6">
                        <flux:checkbox wire:model.live="checkbox_billing_address" label="{{ trans('customer.label.add-billing-address') }}" />

                        @if ($checkbox_billing_address)
                            <!--Country-->
                            <livewire:components.address-select.address-model-select
                                name="country"
                                :placeholder="trans('address.select-country')"
                                :value="request('country')"
                                :searchable="true"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="map-pin"
                                iconLeadingOption="map-pin"
                                iconVariantSelected="solid"
                                iconClassSelected="text-red-500 size-5"
                            />
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Province-->
                                <livewire:components.address-select.children-address-model-select
                                    name="province"
                                    children="country"
                                    :searchable="true"
                                    :placeholder="trans('address.select-province')"
                                    :value="request('province')"
                                    :depends-on="['country']"
                                    :depends-on-values="['country' => request('country')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                                <!--City-->
                                <livewire:components.address-select.children-address-model-select
                                    name="city"
                                    children="province"
                                    :searchable="true"
                                    :placeholder="trans('address.select-city')"
                                    :value="request('city')"
                                    :depends-on="['province']"
                                    :depends-on-values="['province' => request('province')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                            </div>
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--District-->
                                <livewire:components.address-select.children-address-model-select
                                    name="district"
                                    children="city"
                                    :searchable="true"
                                    :placeholder="trans('address.select-district')"
                                    :value="request('district')"
                                    :depends-on="['city']"
                                    :depends-on-values="['city' => request('city')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                                <!--Subdistrict-->
                                <livewire:components.address-select.children-address-model-select
                                    name="subdistrict"
                                    children="district"
                                    :searchable="true"
                                    :placeholder="trans('address.select-sub-district')"
                                    :value="request('subdistrict')"
                                    :depends-on="['district']"
                                    :depends-on-values="['district' => request('district')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                            </div>
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Address -->
                                <flux:input wire:model="input.address" id="address" type="text" :invalid="$errors->first('address')" variant="floating" name="address" :label="__('user.label.address')"
                                    autofocus autocomplete="address" placeholder="{{ __('customer.ph.address') }}" />
                                <!--phone -->
                                <flux:input wire:model="input.phone" id="phone" type="text" :invalid="$errors->first('phone')" autofocus autocomplete="phone" variant="floating" name="phone" :label="__('user.label.phone')"
                                    placeholder="{{ __('customer.ph.phone') }}" />
                            </div>
                        @endif

                        <div class="flex gap-2">
                            <flux:spacer />
                            <flux:button wire:click="back(2)" variant="primary" icon="arrow-left" class="cursor-pointer">
                                {{ __('Back') }}
                            </flux:button>
                            <flux:button type="submit" variant="primary" iconTrailing="arrow-right" class="cursor-pointer">
                                {{ __('customer.button.save') }}
                            </flux:button>

                        </div>
                    </div>
                    @endif

                </form>
            </div>
        </flux:modal>
    @endif
</div>
