<div>
    @if ($editActivationCustomerPaketModal)
        <flux:modal wire:model="editActivationCustomerPaketModal" class="md:w-96 w-[90%]">
            <div>
                <flux:heading size="lg">
                    {{ trans('customer.paket.alert.header-edit-activation-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->first_name,
                    ]) }}
                </flux:heading>
            </div>
            <flux:separator variant="subtle" class="my-4" />

            <form wire:submit='edit_activation_paket'>
                <div class="space-y-2">
                    <flux:input wire:model.live.debounce.500ms="input.activation_date" type="date" name='activation_date'
                        label="{{ trans('billing.label.activation-date') }}"/>

                    <div>
                        <flux:label>{{ trans('customer.label.start-date') }}</flux:label>
                        <flux:select wire:model.change="input.selectStartDate">
                             @foreach ($this->dates as $date)
                                <flux:select.option value="{{ \Carbon\Carbon::parse($date)->format('Y-m-d') }}" :selected="\Carbon\Carbon::parse($date)->format('Y-m') === \Carbon\Carbon::parse($customerPaket->start_date)->format('Y-m') ? true : false">
                                    {{ \Carbon\Carbon::parse($date)->format('d F Y') }}
                                </flux:select.option>
                            @endforeach
                        </flux:select>
                        <flux:error name="selectStartDate"/>
                    </div>

                    <flux:callout color="blue" icon="information-circle">
                        <flux:callout.heading>Expired Paket</flux:callout.heading>
                        <flux:callout.text>
                            {{ trans('customer.label.expired-date') .': '.\Carbon\Carbon::parse($expiredDate)->format('d F Y') }}
                        </flux:callout.text>

                        <flux:callout.text>
                            {{ trans('customer.label.next-bill') .': '.\Carbon\Carbon::parse($nextBilledAt)->format('d F Y') }}
                        </flux:callout.text>
                    </flux:callout>

                    <flux:separator variant="subtle" class="my-4" />
                    <div class="flex gap-2">
                        <flux:spacer />
                        <flux:button style="cursor: pointer;" variant="ghost" size="sm"
                            wire:click="$set('editActivationCustomerPaketModal', false)">
                            {{ trans('customer.button.cancel') }}
                        </flux:button>
                        <flux:button type="submit" variant="primary" icon="check" style="cursor: pointer;"
                            size="sm">
                            {{ trans('customer.paket.button.update') }}
                        </flux:button>
                    </div>
                </div>
            </form>

        </flux:modal>
    @endif
</div>
