<div>
    @if ($editCustomerPaketAddressModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="editCustomerPaketAddressModal" :dismissible="false"
            @close="closeModal()">
            <div class="space-y-6">
                <form wire:submit="updateCustomerPaketAddress">
                     @if($currentStep === 1)
                    <div class="space-y-6">
                        <div>
                            <flux:heading size="lg">
                                {{ trans('customer.paket.update-installation-address', ['customer' => $customerPaket->user->full_name]) }}
                            </flux:heading>
                            <flux:subheading>
                                {{ trans('customer.paket.update-installation-address', ['customer' => $customerPaket->user->full_name]) }}
                            </flux:subheading>

                            @if ($errors->any())
                                <flux:callout variant="danger" icon="exclamation-triangle">
                                    <flux:callout.heading>Error</flux:callout.heading>
                                        <flux:callout.text>
                                            <ol class="list-decimal text-xs">
                                                @foreach ($errors->all() as $error)
                                                    <li>
                                                        {{ $error }}
                                                    </li>
                                                @endforeach
                                            </ol>
                                        </flux:callout.text>
                                </flux:callout>
                            @endif
                        </div>

                        <!--Country-->
                        <livewire:components.address-select.address-model-select
                            name="country"
                            :placeholder="trans('address.select-country')"
                            :value="request('country')"
                            :searchable="true"
                            iconLeading="magnifying-glass"
                            iconLeadingSelected="map-pin"
                            iconLeadingOption="map-pin"
                            iconVariantSelected="solid"
                            iconClassSelected="text-red-500 size-5"
                        />
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--Province-->
                            <livewire:components.address-select.children-address-model-select
                                name="province"
                                children="country"
                                :searchable="true"
                                :placeholder="trans('address.select-province')"
                                :value="request('province')"
                                :depends-on="['country']"
                                :depends-on-values="['country' => request('country')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                            <!--City-->
                            <livewire:components.address-select.children-address-model-select
                                name="city"
                                children="province"
                                :searchable="true"
                                :placeholder="trans('address.select-city')"
                                :value="request('city')"
                                :depends-on="['province']"
                                :depends-on-values="['province' => request('province')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                        </div>
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--District-->
                            <livewire:components.address-select.children-address-model-select
                                name="district"
                                children="city"
                                :searchable="true"
                                :placeholder="trans('address.select-district')"
                                :value="request('district')"
                                :depends-on="['city']"
                                :depends-on-values="['city' => request('city')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                            <!--Subdistrict-->
                            <livewire:components.address-select.children-address-model-select
                                name="subdistrict"
                                children="district"
                                :searchable="true"
                                :placeholder="trans('address.select-sub-district')"
                                :value="request('subdistrict')"
                                :depends-on="['district']"
                                :depends-on-values="['district' => request('district')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                        </div>
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--Address -->
                            <flux:input wire:model="input.address" id="address" type="text" :invalid="$errors->first('address')" variant="floating" name="address" :label="__('user.label.address')"
                                autofocus autocomplete="address" placeholder="{{ __('customer.ph.address') }}" />
                            <!--phone -->
                            <flux:input wire:model="input.phone" id="phone" type="text" :invalid="$errors->first('phone')" autofocus autocomplete="phone" variant="floating" name="phone" :label="__('user.label.phone')"
                                placeholder="{{ __('customer.ph.phone') }}" />
                        </div>

                        <div class="flex gap-2">
                            <flux:spacer />

                            <flux:button wire:click="updateInstallationAddress" variant="primary"
                                iconTrailing="arrow-right">
                                {{ __('Next') }}
                            </flux:button>

                        </div>
                    </div>

                    @elseif($currentStep === 2)
                    <div class="space-y-6">
                        <div>
                            <flux:heading size="lg">
                                {{ trans('customer.paket.update-billing-address', ['customer' => $customerPaket->user->full_name]) }}
                            </flux:heading>
                            <flux:subheading>
                                {{ trans('customer.paket.update-billing-address', ['customer' => $customerPaket->user->full_name]) }}
                            </flux:subheading>
                        </div>

                        <livewire:components.address-select.address-model-select
                            name="country"
                            :placeholder="trans('address.select-country')"
                            :value="request('country')"
                            :searchable="true"
                            iconLeading="magnifying-glass"
                            iconLeadingSelected="map-pin"
                            iconLeadingOption="map-pin"
                            iconVariantSelected="solid"
                            iconClassSelected="text-red-500 size-5"
                        />
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--Province-->
                            <livewire:components.address-select.children-address-model-select
                                name="province"
                                children="country"
                                :searchable="true"
                                :placeholder="trans('address.select-province')"
                                :value="request('province')"
                                :depends-on="['country']"
                                :depends-on-values="['country' => request('country')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                            <!--City-->
                            <livewire:components.address-select.children-address-model-select
                                name="city"
                                children="province"
                                :searchable="true"
                                :placeholder="trans('address.select-city')"
                                :value="request('city')"
                                :depends-on="['province']"
                                :depends-on-values="['province' => request('province')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                        </div>
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--District-->
                            <livewire:components.address-select.children-address-model-select
                                name="district"
                                children="city"
                                :searchable="true"
                                :placeholder="trans('address.select-district')"
                                :value="request('district')"
                                :depends-on="['city']"
                                :depends-on-values="['city' => request('city')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                            <!--Subdistrict-->
                            <livewire:components.address-select.children-address-model-select
                                name="subdistrict"
                                children="district"
                                :searchable="true"
                                :placeholder="trans('address.select-sub-district')"
                                :value="request('subdistrict')"
                                :depends-on="['district']"
                                :depends-on-values="['district' => request('district')]"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="check"
                                iconVariantSelected="solid"
                                iconClassSelected="text-green-500 size-5"
                            />
                        </div>
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--Address -->
                            <flux:input wire:model="input.address" id="address" type="text" :invalid="$errors->first('address')" variant="floating" name="address" :label="__('user.label.address')"
                                autofocus autocomplete="address" placeholder="{{ __('customer.ph.address') }}" />
                            <!--phone -->
                            <flux:input wire:model="input.phone" id="phone" type="text" :invalid="$errors->first('phone')" autofocus autocomplete="phone" variant="floating" name="phone" :label="__('user.label.phone')"
                                placeholder="{{ __('customer.ph.phone') }}" />
                        </div>

                        <div class="flex gap-2">
                            <flux:spacer />
                            <flux:button wire:click="showEditCustomerPaketModal('{{ $customerPaket->slug }}')" variant="primary" icon="arrow-left">
                                {{ __('Back') }}
                            </flux:button>
                            <flux:button type="submit" variant="primary" iconTrailing="arrow-right">
                                {{ __('customer.button.save') }}
                            </flux:button>

                        </div>
                    </div>
                    @endif
                </form>
            </div>
        </flux:modal>
    @endif
</div>
