<div>
    @if ($editStartDateModal)
        <flux:modal wire:model="editStartDateModal" class="md:w-96 w-[90%]">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        Edit Start Date
                    </flux:heading>
                </div>
                <form wire:submit='edit_start_date'>
                    <div class="space-y-4">
                        <div>
                            <flux:input wire:model.change="input.start_date" type="date" name='start_date'
                            label="{{ trans('Start Date') }}" min="{{ \Carbon\Carbon::now()->sub($customerPaket->getRenewalPeriod())->startOfMonth()->format('Y-m-d') }}"
                            max="{{ \Carbon\Carbon::now()->addMonth()->format('Y-m-d') }}" />
                            <flux:error name="selectStartDate"/>
                        </div>

                        <flux:callout color="blue" icon="information-circle">
                        <flux:callout.heading>Expired Paket</flux:callout.heading>
                        <flux:callout.text>
                            {{ trans('customer.label.expired-date') .': '.\Carbon\Carbon::parse($expiredDate)->format('d F Y') }}
                        </flux:callout.text>

                        <flux:callout.text>
                            {{ trans('customer.label.next-bill') .': '.\Carbon\Carbon::parse($nextBilledAt)->format('d F Y') }}
                        </flux:callout.text>
                    </flux:callout>

                        <flux:separator variant="subtle" class="my-4" />
                        <div class="flex gap-2">
                            <flux:spacer />
                            <flux:button style="cursor: pointer;" variant="ghost" size="sm"
                                wire:click="$set('editStartDateModal', false)">
                                {{ trans('customer.button.cancel') }}
                            </flux:button>
                            <flux:button type="submit" variant="primary" icon="check" style="cursor: pointer;"
                                size="sm">
                                {{ trans('customer.paket.button.update') }}
                            </flux:button>
                        </div>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
