<div>
    @if ($restoreCustomerPaketModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="restoreCustomerPaketModal" :dismissible="false">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('customer.alert.header-restore-customer-paket', ['customer_paket' => $customerPaket->paket->name]) }}
                    </flux:heading>
                    <flux:subheading>
                        {{ trans('customer.alert.content-restore-customer-paket', ['customer_paket' => $customerPaket->paket->name]) }}
                    </flux:subheading>
                </div>

                <flux:checkbox wire:model.live="input.restoreOnMikrotik" label="{{ trans('customer.label.restore-on-mikrotik') }}" description="Warning! If uncheck, customer paket will be reset!"    />

                <div class="flex items-center justify-end gap-2">
                    <flux:button  wire:click="$set('restoreCustomerPaketModal', false)" variant="ghost" icon="x-circle" style="cursor: pointer">
                        {{ trans('user.button.cancel') }}
                    </flux:button>
                    <flux:button wire:click="restoredCustomerPaket" :variant="$input['restoreOnMikrotik'] ? 'success' : 'danger'" iconTrailing="arrow-uturn-left" style="cursor: pointer">
                        @if ($input['restoreOnMikrotik'])
                            {{ __('Restore') }}
                        @else
                            {{ __('Restore & Reset Data') }}
                        @endif

                    </flux:button>
                </div>
            </div>
        </flux:modal>
    @endif
</div>
