<div>
    @if ($editNameModal)
        <flux:modal wire:model="editNameModal" class="md:w-120 w-[90%]" :dismissible="false" @close="closeModal()">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('Edit Name') }}
                    </flux:heading>
                </div>
                @if ($errors->any())
                    <flux:callout variant="danger" icon="exclamation-triangle">
                        <flux:callout.heading>Error</flux:callout.heading>
                        <flux:callout.text>
                            <ol class="list-decimal text-xs">
                                @foreach ($errors->all() as $error)
                                    <li>
                                        {{ $error }}
                                    </li>
                                @endforeach
                            </ol>
                        </flux:callout.text>
                    </flux:callout>
                @endif
                <form wire:submit="editName" class="space-y-4">
                    <div class="grid md:grid-cols-2 gap-4">
                        <flux:input :invalid="$errors->first('first_name')" wire:model="input.first_name" type="text" variant="floating" name="first_name" :label="__('user.label.first-name')"
                        autofocus autocomplete="first_name" placeholder="{{ __('user.ph.first-name') }}" />
                        <flux:input :invalid="$errors->first('last_name')" wire:model="input.last_name" type="text" variant="floating" name="last_name" :label="__('user.label.last-name')"
                            autofocus autocomplete="last_name" placeholder="{{ __('user.ph.last-name') }}" />
                    </div>

                    <div class="flex items-center justify-end gap-2">
                        <flux:button wire:click="closeModal()" variant="ghost" class="cursor-pointer">
                            {{ __('Cancel') }}
                        </flux:button>
                        <flux:button type="submit" variant="primary" class="cursor-pointer">
                            {{ __('Save') }}
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
