<section class="w-full">
    @php
       $paymentGateway = \App\Models\PaymentGateway::where('is_active', true)->first();
    @endphp
    @include('partials.show-customer-heading')
    <x-layouts.admin-customer.layout :heading="__('customer.billings')" :subheading="__('customer.billings-description')" :user="$user">
        <div class="space-y-2">
            @if ($paymentGateway && $paymentGateway->value === 'tripay' && env('TRIPAY_MODE') === 'development')
                <flux:callout variant="danger" icon="exclamation-triangle">
                    <flux:callout.heading>Payment Gateway</flux:callout.heading>
                        <flux:callout.text>
                            The payment gateway is in developer mode, so don't conduct real transactions with customers. It's used solely for testing payments through the payment gateway.
                        </flux:callout.text>
                </flux:callout>
            @endif
            <div class="flex justify-end">
                <flux:button variant="primary" color="green" size="sm" iconTrailing="arrow-right" class="cursor-pointer" wire:click="dispatch('create-invoice-modal', {user: '{{ $user->username }}'})">
                    {{ __('Create Invoice') }}
                </flux:button>
            </div>
            @php
                $userInvoices = $user->invoices()->orderBy('periode')->paginate(10);
            @endphp
            @if ($userInvoices->hasPages())
                <div class="p-3">
                    {{ $userInvoices->links() }}
                </div>
            @endif
            <x-tables.table class="table-fixed">
                <x-slot name="header">
                    <x-tables.theader>
                        <x-tables.header class="w-2 px-4 py-2">{{ trans('billing.table.no') }}</x-tables.header>
                        <x-tables.header>{{ trans('billing.table.periode') }}</x-tables.header>
                        <x-tables.header>{{ trans('billing.table.deadline') }}</x-tables.header>
                        <x-tables.header class="w-max">{{ trans('billing.table.bill') }}</x-tables.header>
                        <x-tables.header>{{ trans('billing.table.status') }}</x-tables.header>
                        <x-tables.header>Note</x-tables.header>
                        <x-tables.header>{{ trans('billing.table.action') }}</x-tables.header>
                    </x-tables.theader>
                </x-slot>
                <x-slot name="body">
                    @php
                        $websystem = \App\Models\Websystem::first();
                    @endphp
                    @forelse ($userInvoices as $key => $invoice)
                        <x-tables.row>
                            <x-tables.cell class="text-center">{{ $loop->index + 1 }}</x-tables.cell>
                            <x-tables.cell>
                                {{ \Carbon\Carbon::parse($invoice->periode)->format('M Y') }}
                            </x-tables.cell>
                            <x-tables.cell align="center">
                                <x-billings.deadline-bill :invoice="$invoice" />
                            </x-tables.cell>
                            <x-tables.cell>
                                <x-billings.bill-amount :invoice="$invoice" />
                            </x-tables.cell>
                            <x-tables.cell>
                                <x-billings.status-payment :invoice="$invoice" />
                            </x-tables.cell>
                            <x-tables.cell>
                                {{ $invoice->notes }}
                            </x-tables.cell>
                            <x-tables.cell>
                                <div class="flex justify-end">
                                    <x-billings.bill-action :invoice="$invoice" />
                                </div>

                            </x-tables.cell>

                        </x-tables.row>
                    @empty
                        <x-tables.row>
                            <x-tables.cell colspan=7 class="sm:hidden">
                                <div class="flex justify-center items-center">
                                    <span class="font-medium py-8 text-gray-400 text-xl">
                                        {{ trans('billing.notfound') }}
                                    </span>
                                </div>
                            </x-tables.cell>
                        </x-tables.row>
                    @endforelse
                    @php
                        $billingUnpayment = $user->invoices->whereNull('paid_at');
                    @endphp
                    @if (count($billingUnpayment))
                        <x-tables.row>
                                @php
                                    $whatsappGatewayDisabled = \App\Models\WhatsappGateway\WhatsappGatewayGeneral::first()
                                        ->disabled;
                                @endphp
                                <x-billings.total-bill-footer :user="$user" :whatsappGatewayDisabled="$whatsappGatewayDisabled" />
                        </x-tables.row>
                    @endif

                </x-slot>
            </x-tables.table>
        </div>
        <livewire:admin.billings.modal.billing-payment />
        <livewire:admin.billings.modal.add-discount />
        <livewire:admin.billings.modal.sub-discount />
        <livewire:admin.billings.modal.delete-invoice/>
        <livewire:admin.customers.modal.edit-customer-modal />
        <livewire:admin.customers.modal.customer-paket.create-invoice />
        <livewire:admin.customers.modal.customer-paket.create-invoice-file />
    </x-layouts.admin-customer.layout>

</section>
