<div class="flex h-full w-full flex-1 flex-col gap-4 rounded-xl">
    <!--General Log-->
    <flux:callout icon="document-text" variant="warning">
        <flux:callout.heading>General Log</flux:callout.heading>
        <flux:callout.text>
            @php
                $generalLogs = \App\Models\GeneralLog::limit(5)->orderBy('created_at', 'DESC')->get();
            @endphp
            <div class="space-y-2">
                <ol class="list-decimal text-xs">
                @forelse ($generalLogs as $generalLog)
                    @php
                        $logMsg = '';
                        foreach($generalLog->log_data as $log_data){
                            $logMsg = $log_data['log_history'];
                        }
                    @endphp
                    <li>
                        <flux:text class="text-xs" :color="$generalLog->log_type === App\Services\GeneralLogServices::CUSTOMER_PAKET_EXPIRED ? 'rose': ($generalLog->log_type === App\Services\GeneralLogServices::CREATE_INVOICE ? 'teal' : 'sky')">
                            {{ $logMsg. ' by '.$generalLog->author }} at {{ \Carbon\Carbon::parse($generalLog->created_at)->format('d F Y H:i') }}
                        </flux:text>
                    </li>
                @empty
                <flux:text class="text-xs">
                    Log empty
                </flux:text>
                @endforelse
                </ol>
            </div>
        </flux:callout.text>
    </flux:callout>

    <div class="grid auto-rows-min gap-4 md:grid-cols-3">
        <!--Offline PPP Paket-->
         @php
           $customerPppPakets = \App\Models\Customers\CustomerPaket::whereHas('customer_ppp_paket')->with('customer_ppp_paket')->get();
           // $customerPppPakets = $customerPakets->whereHas('customer_ppp_paket');
            $offlineCustomerPppPakets = $customerPppPakets->sortByDesc('updated_at')->where('online', false);
        @endphp
        <flux:callout icon="power" :variant="$customerPppPakets->count() > 0 ? ($offlineCustomerPppPakets->count() > 0 ? 'danger' : 'success') : 'success'">
            <flux:callout.heading>
                Offline PPP Customer {{ $offlineCustomerPppPakets->count() }} from {{ $customerPppPakets->count() }}
            </flux:callout.heading>
            <flux:callout.text>
                <ol class="list-decimal text-xs">
                 @forelse ($offlineCustomerPppPakets->slice(0,5) as $offlineCustomerPppPaket)
                    <li>
                        <div class="md:grid grid-cols-3 gap-2">
                            <div class="col-span-2">
                                <flux:text class="text-xs font-semibold" color="red">
                                    {{ $offlineCustomerPppPaket->user->full_name }}
                                </flux:text>
                                <flux:text class="text-xs" color="red">
                                    {{ $offlineCustomerPppPaket->paket->mikrotik->name }}
                                </flux:text>
                            </div>
                            <div>
                                <flux:text class="text-xs" color="red">
                                     {{ \Carbon\Carbon::parse($offlineCustomerPppPaket->updated_at)->format('d M Y h:i')}}
                                </flux:text>
                            </div>
                        </div>
                    </li>
                 @empty
                </ol>
                <flux:text class="text-xs">
                    @if ($offlineCustomerPppPakets->count() > 0)
                        All Customer Online
                    @else
                        Dont have customer
                    @endif
                </flux:text>
                @endforelse

            </flux:callout.text>
        </flux:callout>

        <!--Offline IP Static Paket-->
         @php
            $countCustomerStaticPakets = \App\Models\Customers\CustomerStaticPaket::orderBy('updated_at', 'DESC')->count();
            $offlineCustomerStaticPakets = \App\Models\Customers\CustomerStaticPaket::whereOnline(false)
            ->orderBy('updated_at', 'DESC')
            ->get();
        @endphp
        <flux:callout icon="power" :variant="$countCustomerStaticPakets > 0 ? ($offlineCustomerStaticPakets->count() > 0 ? 'danger' : 'success') : 'success'">
            <flux:callout.heading>
                Offline IP Static Customer {{ $offlineCustomerStaticPakets->count() }} from {{ $countCustomerStaticPakets }}
            </flux:callout.heading>
            <flux:callout.text>
                <ol class="list-decimal text-xs">
                 @forelse ($offlineCustomerStaticPakets->slice(0, 4) as $offlineCustomerStaticPaket)
                    <li>
                        <flux:text class="text-xs" color="red">
                            {{ $offlineCustomerStaticPaket->customer_paket->user->full_name }} - {{ $offlineCustomerStaticPaket->paket->mikrotik->name }} - {{ \Carbon\Carbon::parse($offlineCustomerStaticPaket->updated_at)->format('d M Y h:i')}}
                        </flux:text>
                    </li>
                 @empty
                </ol>
                <flux:text class="text-xs">
                    @if ($countCustomerStaticPakets > 0)
                        All Customer Online
                    @else
                        Dont have customer
                    @endif

                </flux:text>
                @endforelse

            </flux:callout.text>
        </flux:callout>

        <!--Mikrotik Histories-->
        <flux:callout icon="document-text" variant="warning">
             @php
                $histories = \App\Models\Servers\MikrotikClientHistory::orderBy('created_at','DESC')->get();
            @endphp
            <flux:callout.heading>
                {{ $histories->count() }} Histories
            </flux:callout.heading>
            <flux:callout.text>
                <ol class="list-decimal text-xs">
                 @forelse ($histories->slice(0, 4) as $history)
                    <li>
                        <div class="md:grid grid-cols-3 gap-2">
                            <div class="col-span-2">
                                <flux:text class="text-xs font-semibold" :color="$history->status == 'up' ? 'green' : 'red'">
                                    {{ $history->user->full_name }} - {{ $history->status }}
                                </flux:text>
                                <flux:text class="text-xs">
                                    {{ $history->type }} - {{ $history->mikrotik->name }}
                                </flux:text>
                            </div>
                            <div>
                                <flux:text class="text-xs" :color="$history->status == 'up' ? 'green' : 'red'">
                                     {{ \Carbon\Carbon::parse($history->created_at)->translatedFormat('d M Y H:i') }}
                                </flux:text>
                            </div>
                        </div>

                    </li>
                 @empty
                </ol>
                <flux:text class="text-xs">
                    No history
                </flux:text>
                @endforelse
            </flux:callout.text>
        </flux:callout>
    </div>

    <div class="grid auto-rows-min gap-4 md:grid-cols-3">
        <!--Login Histories-->
        <flux:callout icon="document-text">
            @php
                $loginHistories = \App\Models\LoginHistory::limit(5)->orderBy('created_at', 'DESC')->get();
            @endphp
            <flux:callout.heading>
                Login Histories
            </flux:callout.heading>
            <flux:callout.text>
                <ol class="list-decimal text-xs">
                 @forelse ($loginHistories as $loginHistory)
                    <li>
                        <div class="md:flex gap-1 justify-between">
                            <div class="flex justify-start mb-1 sm:mb-0">
                                <flux:text class="text-xs">
                                    {{$loginHistory->user->full_name }}
                                </flux:text>
                            </div>
                            <div class="flex justify-between">
                                <flux:text class="text-xs">
                                     {{ \Carbon\Carbon::parse($loginHistory->created_at)->diffForHumans() }}
                                </flux:text>
                            </div>
                        </div>
                    </li>
                 @empty
                </ol>
                <flux:text class="text-xs">
                    No login history
                </flux:text>
                @endforelse
            </flux:callout.text>
        </flux:callout>

        <!--Register Histories-->
        <flux:callout icon="document-text">
            @php
                $newestUsers = \App\Models\User::limit(5)->orderBy('created_at', 'DESC')->get();
            @endphp
            <flux:callout.heading>
                Newest User
            </flux:callout.heading>
            <flux:callout.text>
                <ol class="list-decimal text-xs">
                 @forelse ($newestUsers as $user)
                    <li>
                        <div class="md:flex gap-1 justify-between">
                            <div class="flex justify-start mb-1 sm:mb-0">
                                <flux:text class="text-xs">
                                    {{ $user->full_name }}
                                </flux:text>
                            </div>
                            <div class="flex justify-between">
                                <flux:text class="text-xs">
                                     {{ \Carbon\Carbon::parse($user->created_at)->diffForHumans() }}
                                </flux:text>
                            </div>
                        </div>
                    </li>
                 @empty
                </ol>
                <flux:text class="text-xs">
                    No Newest User
                </flux:text>
                @endforelse
            </flux:callout.text>
        </flux:callout>

        <!--Payment Histories-->
        <flux:callout icon="document-check">
            @php
                $paymentHistories = \App\Models\Billings\PaymentHistory::orderBy('created_at', 'DESC')->paginate(5);
            @endphp
            <div class="flex justify-between">
                <div class="justify-start">
                    <flux:callout.heading>
                        Payment Histories
                    </flux:callout.heading>
                </div>
                <div class="justify-end">
                    <flux:button size="xs" variant="primary" color="green" class="cursor-pointer" :href="route('billings.management.payments')" wire:navigate>
                        View All
                    </flux:button>
                </div>
            </div>

            <flux:callout.text>
                <ol class="list-decimal text-xs">
                 @forelse ($paymentHistories as $paymentHistory)
                    <li>
                        <div class="md:grid grid-cols-4 gap-2">
                            <div class="col-span-3">
                                <flux:text class="text-xs font-semibold">
                                    {{ $paymentHistory->customer_name }}
                                </flux:text>
                                <flux:text class="text-xs">
                                    {{ $paymentHistory->customer_address }}
                                </flux:text>
                            </div>
                            <div>
                                <flux:text class="text-xs">
                                     {{ \Carbon\Carbon::parse($paymentHistory->cretaed_at)->format('d M Y H:i') }}
                                </flux:text>
                            </div>
                        </div>
                    </li>
                 @empty
                </ol>
                <flux:text class="text-xs">
                    No Newest Payment
                </flux:text>
                @endforelse
            </flux:callout.text>
        </flux:callout>



    </div>


    <!-- Billing Chart-->
    <div class="relative h-full overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700 ">

            <div class="p-4 flex-1" style="height: 30rem;">
                <div class="flex flex-row gap-2">
                    <div class="w-1/2">
                        <flux:heading size="lg" level="3" class="mb-1">
                            Billing Status
                        </flux:heading>
                    </div>
                    <x-select wire:model.change="search_with_year" id="search_with_year" name="search_year"
                        class="w-1/2" size="xs">
                        @foreach ($years as $year)
                        <option value="{{ $year->year }}">
                            {{ $year->year }}
                        </option>
                        @endforeach
                        <option value="all-year">{{ __('billing.ph.all-year') }}</option>
                    </x-select>
                </div>

                @if (count($billingPakets) > 0)
                <livewire:livewire-column-chart key="{{ $billingChart->reactiveKey() }}"
                    :column-chart-model="$billingChart" class="h-250" />
                @endif
            </div>

    </div>

</div>
