<section class="w-full">
    <x-layouts.help>
        <div class="space-y-6">
            <flux:callout icon="server" color="zinc">
                <flux:callout.heading>
                    Konfigurasi Server menggunakan Aapanel
                </flux:callout.heading>


                <flux:callout.text>
                    Agar aplikasi Customer Management 2 ini dapat bekerja secara maksimal, anda harus melakukan konfigurasi di Server Aapanel.
                </flux:callout.text>
            </flux:callout>

            <flux:callout icon="server" color="zinc">
                <flux:callout.heading>
                    Konfigurasi Supervisor
                </flux:callout.heading>

                <div class="space-y-4">
                    <flux:callout.text>
                        Jika server anda belum terinstall Supervisor, lakukan instalasi terlebih dahulu.
                    </flux:callout.text>

                    <flux:callout.text>
                        Untuk melakukan instalasi supervisor, buka terminal dan login. Kemudian ketikkan perintah berikut:
                        <div class="space-y-2">
                            <flux:input size="sm" value="sudo apt update" copyable readonly/>
                            <flux:input size="sm" value="sudo apt-get install supervisor" copyable readonly/>
                        </div>
                    </flux:callout.text>
                    <flux:callout.text>
                        Kemudian buat file dengan perintah
                    </flux:callout.text>
                    <div class="space-y-2">
                        <flux:input size="sm" value="sudo nano /etc/supervisor/conf.d/customer-management.conf" copyable readonly/>
                        <flux:text>
                            Kemudian masukkan kode berikut
                        </flux:text>
                        <flux:callout>
                            <flux:text class="text-blue-800">
                                [program:customer]<br>
                                process_name=%(program_name)s_%(process_num)02d<br>
                                command=php <span class="text-red-500">/www/wwwroot/nama_directory_customer_management</span>/artisan queue:work database --sleep=3 --tr><br>
                                autostart=true<br>
                                autorestart=true<br>
                                stopasgroup=true<br>
                                killasgroup=true<br>
                                user=root<br>
                                numprocs=8<br>
                                redirect_stderr=true<br>
                                stdout_logfile=<span class="text-red-500">/www/wwwroot/nama_directory_customer_management</span>/customer-management-worker.log<br>
                                stopwaitsecs=3600<br>
                            </flux:text>
                        </flux:callout>
                        <flux:callout.text>
                            * Untuk text berwarna merah silahkan diganti sesuai lokasi directory customer management.
                        </flux:callout.text>
                    </div>
                </div>

            </flux:callout>

            <flux:callout icon="server" color="zinc">
                <flux:callout.heading>
                    Konfigurasi Cronjob
                </flux:callout.heading>

                <div class="space-y-4">
                    <flux:callout.text>
                        Konfigurasi cronjob diperlukan untuk mengirim notifikasi pesan wa, membuat invoice dan isolir otomatis.
                    </flux:callout.text>

                    <flux:callout.text>
                        Buka Aapanel, kemudian pilih menu <flux:badge icon="calendar-days">Cron</flux:badge> dan pada tab panel pilih menu <flux:badge>Cron Job</flux:badge>
                    </flux:callout.text>
                    <flux:callout.text>
                        Klik tombol <flux:button size="xs" variant="primary" color="green">Add Task</flux:button>
                    </flux:callout.text>
                    <div class="border rounded-lg">
                        <div class="bg-gray-300 rounded-t-lg p-2">
                            <flux:text class="text-gray-700">Add Task</flux:text>
                        </div>
                        <div class="border rounded-b-lg px-10 py-5 space-y-4">
                            <div class="grid grid-cols-5 ">
                                <flux:label>Task type</flux:label>
                                <div class="col-span-4">
                                    <flux:input value="Shell Script" readonly/>
                                </div>
                            </div>

                            <div class="grid grid-cols-5">

                                <flux:label>Task name</flux:label>

                                <div class="col-span-4">
                                    <flux:input value="Cron Customer Management" readonly/>
                                </div>
                            </div>
                            <div class="grid grid-cols-5">
                                <flux:label>Execute cycle</flux:label>
                                <div class="col-span-4 flex gap-4">
                                    <flux:input value="N Minutes" readonly/>
                                    <flux:input value="10 Minutes" readonly/>
                                    <flux:text>Starting at minute 0 of each hour and executed every 10 minutes</flux:text>
                                </div>
                            </div>

                            <div class="grid grid-cols-5">
                                <flux:label>Execute user</flux:label>
                                <div class="col-span-4">
                                    <flux:input value="root" readonly/>
                                </div>
                            </div>

                            <div class="grid grid-cols-5">
                                <flux:label>Script content</flux:label>
                                <div class="col-span-4 border rounded-lg bg-white p-4 text-zinc-600 text-sm">
                                   /www/server/php/<span class="text-red-500">php_version</span>/bin/php /<span class="text-red-500">www/wwwroot/nama_directory_customer_management</span>/artisan schedule:run 1>> /dev/null 2>&1
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="text-sm text-gray-700 space-y-2">
                        <div>
                            <span class="text-red-500">php_version</span> : diganti dengan versi php, contoh php versi 8.4: <span class="text-red-500">84</span>
                        </div>
                        <div>
                            <span class="text-red-500">www/wwwroot/nama_directory_customer_management</span> : diganti dengan lokasi directory customer management, contoh lokasi default dengan nama direktori customer_management_2: <span class="text-red-500">www/wwwroot/customer_management_2</span>
                        </div>
                        Sehingga penulisan penuhnya menjadi  <span class="text-blue-800">/www/server/php/84/bin/php /www/wwwroot/customer_management_2/artisan schedule:run 1>> /dev/null 2>&1</span>
                    </div>

                </div>

            </flux:callout>
        </div>
    </x-layouts.help>
</section>
