<section class="w-full">
    <x-layouts.help>
        <div class="space-y-6">
            <flux:callout icon="wallet" color="zinc">
                <flux:callout.heading>
                    Memasukkan Pelanggan dari Mikrotik
                </flux:callout.heading>

                <flux:callout.text>
                    Untuk memasukkan customer dari mikrotik, silahkan pergi ke halaman <flux:badge icon="server"><a target="_blank" href="{{route('managements.mikrotiks')}}"> {{trans('menu.servers')}}</a></flux:badge>.
                </flux:callout.text>

                <flux:callout.text>
                    Kemudian pilih tombol View <flux:button size="xs" variant="primary" icon="eye"/>. Halaman ini digunakan untuk mengimport dan mengexport cutomer dan paket ke mikrotik.
                </flux:callout.text>

                <flux:callout.text>
                    <flux:badge size="sm" color="orange" icon="bell-alert">Format PPP Profile di Mikrotik</flux:badge>

                </flux:callout.text>

                <flux:callout.text>
                    Pastikan format profile di mikrotik sudah sesuai. Lihat pada menu <flux:badge size="sm"><a href="{{ route('helps.servers.importProfile') }}" target="_blank">Import Profile</a></flux:badge> untuk lebih lanjut.
                </flux:callout.text>

                <flux:callout.text>
                    Jika sebelumnya anda menggunakan Customer Management Versi 1 dan anda ingin mengatur tanggal aktivasi melalui comment di user secret pada mikrotik, silahkan atur Tag Payment dan Tag Unpayment sesuai dengan Customer Management Versi 1. Anda dapat mengatur Tag Payment dan Tag Unpayment pada pengaturan <flux:button icon="server" target="_blank" href="{{ route('managements.autoisolirs') }}" size="xs" variant="primary">Auto Isolir</flux:button> kemudian pilih <flux:button variant="primary" icon="pencil" size="xs">General</flux:button>.
                    <br>Contoh:
                </flux:callout.text>

                <flux:callout.text>
                    <div class="mt-4 mb-4">
                        <flux:callout class="md:w-120">
                            <flux:callout.heading> {{ trans('autoisolir.title.general') }}</flux:callout.heading>
                            <div class="space-y-6">

                                <flux:input.group>
                                    <flux:input.group.prefix class="w-1/2">{{ trans('autoisolir.label.auto-isolir-driver') }}
                                    </flux:input.group.prefix>
                                    <flux:select name="auto_isolir_driver">
                                        <flux:select.option value="mikrotik">Mikrotik</flux:select.option>
                                        <flux:select.option value="cronjob">Cron Job</flux:select.option>
                                    </flux:select>
                                </flux:input.group>


                                <div class="flex flex-col">
                                    <flux:input.group>
                                        <flux:input.group.prefix class="w-1/2">{{ trans('autoisolir.label.comment-payment') }}
                                        </flux:input.group.prefix>
                                        <flux:input type="text" value="lunas"/>
                                    </flux:input.group>
                                </div>

                                <div class="flex flex-col">
                                    <flux:input.group>
                                        <flux:input.group.prefix class="w-1/2">
                                            {{ trans('autoisolir.label.comment-unpayment') }}
                                        </flux:input.group.prefix>
                                    <flux:input type="text" value="belum_lunas"/>

                                    </flux:input.group>
                                </div>

                                <div class="flex items-center justify-end gap-2">
                                    <flux:button variant="primary">
                                        {{ trans('autoisolir.button.cancel') }}
                                    </flux:button>

                                    <flux:button variant="primary" iconTrailing="arrow-right">
                                        {{ __('autoisolir.button.update') }}
                                    </flux:button>
                                </div>
                            </div>
                        </flux:callout>
                        </div>
                </flux:callout.text>

                <flux:callout.text>
                    Namun jika anda sebelumnya tidak menggunakan Customer Management Versi 1, anda dapat mengatur komen pada User Secret Mikrotik seperti ini <flux:badge>dd-mm-yyyy</flux:badge><br> dd diisi tanggal, mm didsi bulan dan yyyy diisi tahun
                    <br>Contoh:<br>
                    <flux:badge>16-09-2025</flux:badge><br>
                    maka nanti pada tanggal aktivasi Customer adalah 16 September 2025.
                </flux:callout.text>

                <flux:callout.text>
                    Untuk mulai memasukkan customer dari mikrotik, tekan tombol <flux:button variant="primary"
                        size="sm" iconTrailing="arrow-down-tray" style="cursor:pointer">
                        {{ __('mikrotik.button.import-customer-from-mikrotik',['mikrotik' => 'Nama Mikrotik']) }}
                    </flux:button> dan ikuti petunjuk selanjutnya.
                </flux:callout.text>

                <flux:callout.text>
                     <flux:badge color="orange" icon="bell-alert" class="mb-2">!Perhatian</flux:badge><br>
                    Jika pada <flux:badge color="sky" size="sm" class="mb-2"><a href="{{ route('managements.websystem') }}" target="_blank">General Setting</a></flux:badge> Customer Management menggunakan <flux:badge color="sky" size="sm" class="mb-2">Queue Connection: sync</flux:badge>, anda hanya bisa mengimport profile sebanyak <flux:badge color="sky" size="sm" class="mb-2">Max. Process</flux:badge>. Hal ini dilakukan untuk mengurangi server anda bekerja terlalu berat.
                </flux:callout.text>

            </flux:callout>
        </div>

    </x-layouts.help>
</section>
