<section class="w-full">
    <x-layouts.help>
        <flux:callout icon="envelope" color="zinc">
            <flux:callout.heading>
                Format Standar Pesan Pembayaran Mundur
            </flux:callout.heading>
            <flux:callout.text>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-4 bg-white rounded-lg border p-4">
                        <div>
                            <flux:input wire:model="input.namaPesan"
                                :label="__('whatsapp-gateway.label.name')" type="text" disabled filled
                                iconTrailing="lock-closed" />
                        </div>
                        <flux:field>
                            <flux:textarea wire:model="input.pesan" rows="10" readonly
                                :label="__('whatsapp-gateway.label.message')" type="text" />
                        </flux:field>
                        <flux:field>
                            <flux:textarea wire:model="input.deskripsi"
                                :label="__('whatsapp-gateway.label.description')" type="text" />
                            <flux:error name="description" value="test" />
                        </flux:field>

                        <div class="flex items-center justify-end">
                            <flux:button variant="ghost" class="me-2" style="cursor:pointer">
                                {{ __('device.button.cancel') }}
                            </flux:button>
                            <flux:button variant="primary" style="cursor:pointer">
                                {{ __('device.button.update') }}
                            </flux:button>
                        </div>
                    </div>

                    @php
                        $replace = [
                            '%company%' => env('APP_NAME'),
                            '%name%' =>  auth()->user()->full_name,
                            '%email%' => auth()->user()->email,
                            '%address%' => auth()->user()->user_address->address,
                            '%customer_id%' => auth()->user()->id,
                            '%invoice_number%' => 'INV-12345678',
                            '%transaction_id%' =>  'TR-12345678',
                            '%paket%' => \App\Models\Pakets\Paket::where('price', '>', 0)->first()->name ?? ' Nama Paket',
                            '%periode%' =>  \Carbon\Carbon::now()->startOfMonth()->format('d F Y - ') . \Carbon\Carbon::now()->endOfMonth()->format('d F Y'),
                            '%bill%' => 'Rp.' . number_format(\App\Models\Pakets\Paket::where('price', '>', 0)->first()->price ?? 250000, 2),
                            '%teller%' => auth()->user()->full_name,
                            '%payment_time%' =>  Carbon\Carbon::now()->format('d F Y H:i:s'),
                            '%payment_methode%' => 'Cash'
                        ];
                        $message =  str_replace(array_keys($replace), $replace, $input['pesan']);
                    @endphp
                    <x-whatsapp-preview :send_message="$message" />
                </div>
            </flux:callout.text>
         </flux:callout>

    </x-layouts.help>
</section>
