<div>
    @if ($importCustomerModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="importCustomerModal" :dismissible="false">
            @if ($mikrotikOnline)
                <div class="space-y-6">
                    <div>
                        <flux:heading size="lg">
                            {{ trans('mikrotik.import-customers') }}
                        </flux:heading>
                    </div>

                    <form wire:submit="importCustomer">
                        <div class="space-y-4">
                            <flux:text class="mt-2">
                                {{ __('mikrotik.helper.import-customer-to-mikrotik', [
                                    'maxSecret' => $countDifferentUserSecret,
                                    'countSecret' => $countDifferentUserSecret,
                                    'mikrotik' => $mikrotik->name,
                                ]) }}
                            </flux:text>

                            <div>
                                <flux:input wire:model="input.email_domain" type="text" name='email_domain'
                                    label="{{ trans('Email Domain') }}" placeholder="domain.com"/>
                            </div>

                            <div class="space-y-2">
                                <flux:checkbox wire:model.change="input.use_comment_activation_date" label="{!! __('mikrotik.helper.use_comment_activation_date') !!}"/>
                                @if($input['use_comment_activation_date'])
                                    <flux:button size="xs" title="Change format auto isolir" variant="ghost"
                                        style="cursor: pointer;" icon="pencil" wire:click="$dispatch('edit-general-autoisolir-modal')">
                                        Change format auto isolir
                                    </flux:button>
                                @endif
                                <flux:button :href="route('helps.servers.importCustomer')" target="_blank" size="xs" icon="book-open-text" variant="ghost" class="cursor-pointer">
                                    Please read document how to use it.
                                </flux:button>
                            </div>

                            <flux:input wire:ignore wire:model="input.activation_date" type="date" name='activation_date'
                                label="{{ trans('mikrotik.label.activation-date') }}"
                                max="{{ \Carbon\Carbon::now()->format('Y-m-d') }}" />

                            <div class="flex items-center justify-end gap-2">
                                <flux:button size="sm" wire:click="$set('importCustomerModal', false)" variant="ghost" class="cursor-pointer">
                                    {{ trans('paket.button.cancel') }}
                                </flux:button>

                                <flux:button type="submit" size="sm" iconTrailing="arrow-down-tray" class="cursor-pointer">
                                    {{ __('mikrotik.button.import-user-secrets', [
                                        'maxSecret' => $countDifferentUserSecret,
                                        'countSecret' => $countDifferentUserSecret,
                                    ]) }}
                                </flux:button>
                            </div>
                        </div>
                    </form>
                </div>
            @else
                <div class="space-y-6">
                    <flux:callout variant="danger" >
                        <flux:callout.heading icon="x-circle">Connection Error</flux:callout.heading>

                        <flux:callout.text>
                            Cannot connect to Mikrotik, please check your Mikrotik connection or settings.
                        </flux:callout.text>
                    </flux:callout>
                </div>
            @endif
            <livewire:admin.settings.autoisolir.modal.general />
        </flux:modal>
    @endif
</div>
