<div>
    @if ($deleteAddressModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="deleteAddressModal" :dismissible="false">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('Delete Address ' . $address->name) }}
                    </flux:heading>

                    <flux:text class="mt-2">
                        {!!trans('Are you sure to delete this address? children in this address will also be deleted and this cannot be restored.') !!}
                    </flux:text>
                </div>
                <form wire:submit='deleteAddress' class="space-y-6">

                    <div class="space-y-4">
                        <flux:input wire:model="input.current_password" :label="__('user.label.confirm-password')" viewable
                            type="password" name="current_password" placeholder="{{ __('Input your password') }}" />
                    </div>

                    <div class="flex gap-2">
                        <flux:button class="cursor-pointer" variant="ghost"
                            wire:click="$set('deleteAddressModal', false)">
                            {{ trans('user.button.cancel') }}</flux:button>

                        <flux:button type="submit" variant="danger" icon="trash" class="cursor-pointer">
                            {{ trans('customer.button.delete')}}
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
