<section class="w-full">

    <x-layouts.general-setting heading="Account" subheading="Account to login WA Gateway">
        <x-slot name="menu">
            <x-layouts.whatsapp-gateway.nav-bar/>
        </x-slot>
        @if ($notFound)
            <flux:callout variant="danger" icon="x-circle">
                <flux:callout.heading>{{ $titleMessage }}</flux:callout.heading>
                <flux:callout.text>{{ $errorMessage }}</flux:callout.text>
            </flux:callout>
        @else
            @if ($isError)
                <flux:callout variant="danger" icon="x-circle">
                    <flux:callout.heading>{{ $titleMessage }}</flux:callout.heading>
                    <flux:callout.text>{{ $errorMessage }}</flux:callout.text>
                </flux:callout>
            @else
                <div class="grid lg:grid-cols-2 gap-4 text-gray-600 mt-4">
                    <form wire:submit="update_account" class="space-y-4">
                        <flux:input wire:model="input.email" :label="__('Email')" type="email" autocomplete="email" name="email"/>
                        <flux:input wire:model="input.password" :label="__('New password')" type="password"
                            autocomplete="new-password" viewable name="password"/>
                        <flux:input wire:model="input.password_confirmation" :label="__('Confirm Password')" type="password"
                            autocomplete="new-password" viewable name="password_confirmation"/>
                        <flux:input wire:model="input.current_password" :label="__('Current password')" type="password"
                            autocomplete="current-password" viewable name="current_password"/>

                        <div class="flex items-center justify-end gap-2">
                            <x-action-message class="me-3 text-green-600" on="account-updated">
                                {{ __('Account updated.') }}
                            </x-action-message>
                            <flux:button type="submit" variant="primary" size="sm">
                                Save
                            </flux:button>
                        </div>
                    </form>
                </div>
            @endif
        @endif
    </x-layouts.general-setting>
</section>
