<section class="w-full">
    <x-layouts.general-setting :heading="__('Boot Message')" :subheading="__('Auto reply message.')">
       <x-slot name="menu">
            <x-layouts.whatsapp-gateway.nav-bar-message/>
        </x-slot>
        <div class="my-6 w-full space-y-6">
            <!--x-customer-management.admin-tree-message-->

            <!--Button-->
            <div class="flex justify-end">
                <flux:button size="sm" wire:click="$dispatch('show-reset-boot-message-modal')"
                    style="cursor: pointer;" variant="danger" icon="arrow-path-rounded-square">
                    {!! trans('billing.button.reset-message') !!}
                </flux:button>
            </div>
            <div class="mt-2 text-sm text-zinc-800 dark:text-white overflow-x-auto">
                @foreach ($treeMessages as $message1)
                    <flux:callout color="orange">
                        <div class="grid grid-cols-3 gap-4">
                            <div class="p-2 flex md:flex-row flex-col">
                                <div class="border rounded-lg bg-white dark:bg-white/10 p-2 space-y-2">
                                    <flux:text class="font-semibold">{{ $message1->name }}</flux:text>
                                    <flux:text class="text-xs">{{ $message1->message }}</flux:text>
                                    <flux:callout color="zinc">
                                        <div class="grid grid-cols-3">
                                            <flux:text>Enable</flux:text>
                                            <div class="colspan-2">
                                                <livewire:components.toogle-button :model="$message1" field="disabled"
                                                dispatch="refresh-wa-boot-message" key="{{ now() }}" />
                                            </div>
                                        </div>
                                        <div class="grid grid-cols-3">
                                            <flux:text>Hidden</flux:text>
                                            <div class="colspan-2">
                                                <livewire:components.toogle-button-enable :model="$message1" field="hidden_message" dispatch="refresh-wa-boot-message" key="{{ now() }}" />
                                            </div>
                                        </div>
                                        <div class="grid grid-cols-3">
                                            <flux:text>Action</flux:text>
                                            <div class="colspan-2">
                                                <flux:button wire:click="$dispatch('show-edit-boot-message-modal',{whatsappBootMessage: '{{ $message1->id }}'})" icon="pencil" size="sm"/>
                                            </div>
                                        </div>
                                    </flux:callout>
                                </div>
                            </div>

                            <div class="col-span-2 space-y-2 p-2">
                                @forelse ($message1->childrenMessages as $message2)
                                <flux:callout color="green">
                                <div class="grid grid-cols-2 space-y-2 gap-4">
                                    <div class="border rounded-lg bg-white dark:bg-white/10 p-2 space-y-2">
                                        <flux:text class="font-semibold">{{ $message2->name }}</flux:text>
                                        <flux:text class="text-xs">{{ $message2->message }}</flux:text>
                                        <flux:callout color="zinc">
                                            <div class="grid grid-cols-3">
                                                <flux:text>Enable</flux:text>
                                                <div class="colspan-2">
                                                    <livewire:components.toogle-button :model="$message2" field="disabled"
                                                    dispatch="refresh-wa-boot-message" key="{{ now() }}" />
                                                </div>
                                            </div>
                                            <div class="grid grid-cols-3">
                                                <flux:text>Hidden</flux:text>
                                                <div class="colspan-2">
                                                    <livewire:components.toogle-button-enable :model="$message2" field="hidden_message" dispatch="refresh-wa-boot-message" key="{{ now() }}" />
                                                </div>
                                            </div>
                                            <div class="grid grid-cols-3">
                                                <flux:text>Action</flux:text>
                                                <div class="colspan-2">
                                                    <flux:button wire:click="$dispatch('show-edit-boot-message-modal',{whatsappBootMessage: '{{ $message2->id }}'})" icon="pencil" size="sm"/>
                                                </div>
                                            </div>
                                        </flux:callout>
                                    </div>

                                    <flux:callout color="blue">
                                        <div class="space-y-2 p-2">
                                            @foreach ($message2->childrenMessages as $message3)
                                                <div class="border rounded-lg bg-white dark:bg-white/10 p-2 space-y-2">
                                                    <flux:text class="font-semibold">{{ $message3->name }}</flux:text>
                                                    <flux:text class="text-xs">{{ $message3->message }}</flux:text>
                                                    <flux:callout color="zinc">
                                                        <div class="grid grid-cols-3">
                                                            <flux:text>Enable</flux:text>
                                                            <div class="colspan-2">
                                                                <livewire:components.toogle-button :model="$message3" field="disabled"
                                                                dispatch="refresh-wa-boot-message" key="{{ now() }}" />
                                                            </div>
                                                        </div>
                                                        <div class="grid grid-cols-3">
                                                            <flux:text>Hidden</flux:text>
                                                            <div class="colspan-2">
                                                                <livewire:components.toogle-button-enable :model="$message3" field="hidden_message" dispatch="refresh-wa-boot-message" key="{{ now() }}" />
                                                            </div>
                                                        </div>
                                                        <div class="grid grid-cols-3">
                                                            <flux:text>Action</flux:text>
                                                            <div class="colspan-2">
                                                                <flux:button wire:click="$dispatch('show-edit-boot-message-modal',{whatsappBootMessage: '{{ $message3->id }}'})" icon="pencil" size="sm"/>
                                                            </div>
                                                        </div>
                                                    </flux:callout>
                                                </div>
                                            @endforeach
                                        </div>
                                    </flux:callout>
                                </div>
                                </flux:callout>
                                @empty
                                    <div class="border-b"></div>
                                    <div class="border-l border-b"></div>
                                @endforelse
                            </div>
                        </div>
                    </flux:callout>
                @endforeach
            </div>



        </div>
    </x-layouts.general-setting>
    <livewire:admin.whatsapp-gateway.modal.boot-messages.edit-boot-message />
    <livewire:admin.whatsapp-gateway.modal.boot-messages.reset-messages />

</section>
