<section class="w-full">

    <x-layouts.general-setting heading="Company" subheading="Company to WA Gateway">

       <x-slot name="menu">
            <x-layouts.whatsapp-gateway.nav-bar/>
        </x-slot>

        @if ($notFound)
            <flux:callout variant="danger" icon="x-circle">
                <flux:callout.heading>{{ $titleMessage }}</flux:callout.heading>
                <flux:callout.text>{{ $errorMessage }}</flux:callout.text>
            </flux:callout>
        @else
            @if ($isError)
                <flux:callout variant="danger" icon="x-circle">
                    <flux:callout.heading>{{ $titleMessage }}</flux:callout.heading>
                    <flux:callout.text>{{ $errorMessage }}</flux:callout.text>
                </flux:callout>
            @else
                <div class="lg:w-[50%] w-full">
                    <flux:callout variant="secondary">
                        <flux:callout.heading icon="building-office-2">{{ $companyName }}</flux:callout.heading>
                        <flux:callout.text>To change company name, please contact administrator!</flux:callout.text>
                    </flux:callout>
                </div>

                <div class="grid lg:grid-cols-2 gap-4 text-gray-600 mt-4">
                    <form wire:submit="update_company" class="space-y-4">
                        <div class="grid grid-cols-3">
                            <flux:label>Domain</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.domain" name="domain" />
                                    <flux:error name="domain" />
                                </div>
                            </div>
                        </div>
                        <div class="grid grid-cols-3">
                            <flux:label>Country Code</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.country_code" name="country_code" />
                                    <flux:error name="country_code" />
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:label>Phone</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.phone" name="phone" />
                                    <flux:error name="phone" />
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:label>Address</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.address" name="address" />
                                    <flux:error name="address" />
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:label>Subdistrict</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.subdistrict" name="subdistrict" />
                                    <flux:error name="subdistrict" />
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:label>District</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.district" name="district" />
                                    <flux:error name="district" />
                                </div>
                            </div>
                        </div>
                        <div class="grid grid-cols-3">
                            <flux:label>City</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.city" name="city" />
                                    <flux:error name="city" />
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:label>Province</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.province" name="province" />
                                    <flux:error name="province" />
                                </div>
                            </div>
                        </div>


                        <div class="grid grid-cols-3">
                            <flux:label>Postal Code</flux:label>
                            <div class="col-span-2">
                                <div>
                                    <flux:input wire:model="input.postal_code" name="postal_code" />
                                    <flux:error name="postal_code" />
                                </div>
                            </div>
                        </div>



                        <div class="flex items-center justify-end gap-2">
                            <x-action-message class="me-3 text-green-600" on="company-updated">
                                {{ __('Company updated.') }}
                            </x-action-message>
                            <flux:button type="submit" variant="primary" size="sm">
                                Save
                            </flux:button>
                        </div>
                    </form>
                </div>
            @endif
        @endif
    </x-layouts.general-setting>
</section>
