<div class="space-y-6">
    <x-auth-header :title="\App\Models\Websystem::first()->title ?? env('APP_NAME')" :description="__('Enter your details below to create your account')" />

    <form wire:submit="register_user" class="space-y-6">
        <!-- Email Address -->
        <flux:input wire:model="input.email" id="email" :label="__('Email address')" type="email" name="email"
            autocomplete="email" placeholder="email@example.com" />

        <!-- Password -->
        <flux:input wire:model="input.password" id="password" :label="__('Password')" type="password" name="password"
            autocomplete="new-password" placeholder="Password" />

        <!-- Confirm Password -->
        <flux:input wire:model="input.password_confirmation" id="password_confirmation" :label="__('Confirm password')"
            type="password" name="password_confirmation" autocomplete="new-password" placeholder="Confirm password" />

        <div class="flex items-center justify-end">
            <flux:button wire:click="back_step_two" variant="primary" size="sm" class="me-2">
                {{ __('Back') }}
            </flux:button>
            <flux:button type="submit" variant="primary" color='orange' size="sm">
                {{ __('Create account') }}
            </flux:button>
        </div>
    </form>
    <div class="space-x-1 text-center text-sm text-zinc-600 dark:text-zinc-400">
        {{ __('Already have an account?') }}
        <flux:link :href="route('login')" wire:navigate>{{ __('Log in') }}</flux:link>
    </div>
</div>
