<div class='w-full relative block group/input' data-flux-input>

    @if(is_string($iconLeading))
        <div class="absolute top-0 bottom-0 flex items-center justify-center text-xs text-zinc-400/75 ps-3 start-0">
            <flux:icon :icon="$iconLeading" :variant="$iconVariant" :class="$iconClass" />
        </div>
    @endif

    <input
        id="{{ $name }}"
        name="{{ $name }}"
        type="text"
        placeholder="{{ $placeholder }}"
        class="{{ $styles['searchInput'] }} {{ is_string($iconLeading) ? 'ps-10' : '' }}"
        wire:keydown.enter.prevent="add()"
        wire:model.live.debounce.300ms="searchTerm"
        x-init="isOpen = false"
        x-on:click="isOpen = true"
        x-on:keydown="isOpen = true"
        x-on:keydown.arrow-up="selectUp(@this)"
        x-on:keydown.arrow-down="selectDown(@this)"
        x-on:keydown.enter.prevent="confirmSelection(@this)"
        @if (!$dependingValue)
            disabled
        @endif
    />
</div>
