<div class='w-full relative block group/input' data-flux-input>
    @if(is_string($iconLeadingSelected))
    <div class="absolute top-0 bottom-0 flex items-center justify-center text-xs text-zinc-400/75 ps-3 start-0">
        <flux:icon :icon="$iconLeadingSelected" :variant="$iconVariantSelected" :class="$iconClassSelected" />
    </div>
    @endif

    <button id="{{ $name }}-selected" type="button" class="{{ $styles['searchSelectedOption'] }} {{ is_string($iconLeading) ? 'ps-10' : '' }}"
        x-on:keydown.enter.prevent="removeSelection(@this)" x-on:keydown.space.prevent="removeSelection(@this)" wire:click.prevent="selectValue(null)">
        <span class="{{ $styles['searchSelectedOptionTitle'] }}">
            {{ data_get($selectedOption, 'description', 'Override selectedOption() with keyed array (value, description) for meaningful description') }}
        </span>

        <span>
            <svg class="{{ $styles['searchSelectedOptionReset'] }}" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                    d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                    clip-rule="evenodd" />
            </svg>
        </span>
        <input type="hidden" value="{{ $value }}" name="{{ $name }}">
    </button>
</div>
