<div>
    @if ($createOrderModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="createOrderModal" :dismissible="false" @close="$js.refreshData">
            @php
                $paymentGateway = \App\Models\PaymentGateway::where('is_active', true)->first();
            @endphp
            <div class="space-y-4">
                @if ($paymentGateway && $paymentGateway->value === 'tripay' && env('TRIPAY_MODE') === 'development')
                    <flux:badge icon="bell-alert" color="amber">
                        Demo
                    </flux:badge>
                @endif
                <div class="{{ $currentStep != 1 ? 'hidden' : '' }}">
                    @if ($currentStep == 1)
                        <flux:heading size="lg" class="mb-4">
                            Rincian Pembayaran
                        </flux:heading>
                        <form wire:submit="processOrder">
                            <div class="flex flex-col gap-2">
                                <div class="md:flex justify-between">
                                    <div class="flex justify-start">
                                        <flux:heading>Nama Pelanggan</flux:heading>
                                    </div>
                                    <div class="flex justify-between">
                                        <flux:text>{{ $invoice->customer_paket->user->full_name }}</flux:text>
                                    </div>
                                </div>

                                <div class="md:flex justify-between">
                                    <div class="flex justify-start">
                                        <flux:heading>Nomor Invoice</flux:heading>
                                    </div>
                                    <div class="flex justify-between">
                                        <flux:text>{{ $invoice->invoice_number }}</flux:text>
                                    </div>
                                </div>
                                <div class="md:flex justify-between">
                                    <div class="flex justify-start">
                                        <flux:heading>Periode</flux:heading>
                                    </div>
                                    <div class="flex justify-between">
                                        <flux:text>
                                            {{ \Carbon\Carbon::parse($invoice->start_periode)->format('d F Y') }} -
                                            {{ \Carbon\Carbon::parse($invoice->end_periode)->format('d F Y') }}
                                        </flux:text>
                                    </div>
                                </div>

                                @php
                                    $totalPaid = $invoice->payments->sum('amount');
                                    $totalRefunded = $invoice->payments->sum('refunded_amount');
                                    $netPaid = $totalPaid - $totalRefunded;
                                    $totalBill = $invoice->amount - $invoice->discount + $invoice->tax - $netPaid;
                                @endphp
                                @if ($invoice->tax > 0)
                                    <div class="md:flex justify-between">
                                        <div class="flex justify-start">
                                            <flux:heading>PPN</flux:heading>
                                        </div>
                                        <div class="flex justify-between">
                                            <flux:text>@moneyIDR($invoice->tax)</flux:text>
                                        </div>
                                    </div>
                                @endif

                                <div class="md:flex justify-between">
                                    <div class="flex justify-start">
                                        <flux:heading>Jumlah Tagihan</flux:heading>
                                    </div>
                                    <div class="flex justify-between">
                                        <flux:text> @moneyIDR($totalBill)</flux:text>
                                    </div>
                                </div>
                                <flux:field>
                                    <flux:select wire:model="input.method" label="Metode:">
                                        <flux:select.option value="">Pilih metode</flux:select.option>
                                        @foreach ($paymentChanels as $paymentChanel)
                                            <flux:select.option value="{{ $paymentChanel['code'] }}">
                                                {{ $paymentChanel['name'] }}
                                            </flux:select.option>
                                        @endforeach
                                    </flux:select>
                                    <flux:error name="method" />
                                </flux:field>
                                <flux:separator class="mt-2 mb-2" />
                                <div class="flex items-center justify-end gap-2">
                                    <flux:button size='sm' wire:click="closeModal" variant="ghost"
                                        style="cursor: pointer">Batal
                                    </flux:button>
                                    <flux:button.group>
                                        @if ($invoice->order)
                                            <flux:button size="sm" wire:click="back(2)" variant="primary"
                                                style="cursor: pointer">
                                                Kembali
                                            </flux:button>
                                        @endif
                                        <flux:button size='sm' type="submit" variant="primary"
                                            style="cursor:pointer">
                                            {{ __('Bayar') }}
                                        </flux:button>
                                    </flux:button.group>

                                </div>

                            </div>
                        </form>
                    @endif
                </div>

                <div class="{{ $currentStep != 2 ? 'hidden' : '' }}">
                    @if ($currentStep == 2)
                        <flux:heading size="lg" class="mb-4">
                            Menunggu Pembayaran
                        </flux:heading>
                        <div class="flex flex-col gap-2">
                            <div class="md:flex justify-between">
                                <div class="flex justify-start">
                                    <flux:heading>Nama Pelanggan</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>{{ $order->customer_name }}</flux:text>
                                </div>
                            </div>

                            <div class="md:flex justify-between">
                                <div class="flex justify-start">
                                    <flux:heading>Email Pelanggan</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>{{ $order->customer_email }}</flux:text>
                                </div>
                            </div>

                            <div class="md:flex justify-between">
                                <div class="flex justify-start">
                                    <flux:heading>Telepon Pelanggan</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>{{ $order->customer_phone }}</flux:text>
                                </div>
                            </div>

                            <flux:separator class="my-2" />

                            <div class="md:flex justify-between">
                                <div class="flex justify-start">
                                    <flux:heading>Referensi</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>{{ $order->reference }}</flux:text>
                                </div>
                            </div>
                            <div class="md:flex justify-between">
                                <div class="flex justify-start">
                                    <flux:heading>Nomor Tagihan</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>
                                        {{ $order->merchant_ref }}
                                    </flux:text>
                                </div>
                            </div>

                            <div class="md:flex justify-between">
                                <div class="flex justify-start">
                                    <flux:heading>Metode Pembayaran</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>{{ $order->payment_name }}</flux:text>
                                </div>
                            </div>

                            <div class="md:flex justify-between">
                                <div class="flex justify-start">
                                    <flux:heading>Jumlah Tagihan</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>
                                        @moneyIDR($order->amount)
                                    </flux:text>
                                </div>
                            </div>

                            @if (!is_null($order['qr_url']))
                                <flux:label>Kode QR:</flux:label>
                                <div class="items-center justify-center flex flex-col gap-2">
                                    <div class="items-center justify-center flex rounded-lg border-2 border-neutral-200 dark:border-neutral-700 size-50">
                                        <div class="p-2">
                                            <img src="{{ $order['qr_url'] }}"/>
                                        </div>
                                    </div>
                                    <flux:button variant="primary" size="xs" target="_blank" :href="$order['qr_url']">
                                        Download QR
                                    </flux:button>
                                </div>
                            @elseif (!is_null($order['pay_url']))
                                <flux:callout variant="secondary" icon="information-circle">
                                    <flux:callout.heading>Informasi Pembayaran</flux:callout.heading>
                                    <flux:callout.text>Tekan tautan untuk melakukan pembayaran.
                                        <flux:callout.link class="text-blue-800" :external="true" :href="$order['pay_url']">Bayar Sekarang</flux:callout.link>
                                    </flux:callout.text>
                                </flux:callout>
                            @else
                                <flux:label>Kode Bayar:</flux:label>
                                <flux:input value="{{$order['pay_code']}}" readonly copyable/>
                            @endif

                            <flux:separator class="mt-2 mb-2" />
                            <div class="flex items-center justify-end gap-2">
                                <flux:button size="sm" wire:click="closeModal" variant="ghost"
                                    style="cursor: pointer">Tutup
                                </flux:button>

                                <flux:button.group>
                                    <flux:button size="sm" wire:click='instructions' variant="primary"
                                        style="cursor: pointer">
                                        Lihat Cara Bayar
                                    </flux:button>
                                    <flux:button size="sm" wire:click="changeOrderModal('{{ $order->invoice->id }}')" variant="primary"
                                        style="cursor: pointer">Ganti
                                    </flux:button>
                                </flux:button.group>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="{{ $currentStep != 3 ? 'hidden' : '' }}">
                    @if ($currentStep == 3)
                        <flux:heading size="lg" class="mb-4">
                            Cara Pembayaran
                        </flux:heading>
                        <!-- Instruction -->
                        <div class="flex flex-col gap-4">
                            @foreach ($inctructions as $instruction)
                                <div>
                                    <flux:heading>{{ $loop->index + 1 }}. {{ $instruction['title'] }}
                                    </flux:heading>
                                    @foreach ($instruction['steps'] as $step)
                                        <flux:text>
                                            {{ $loop->index + 1 }}. {!! $step !!}
                                        </flux:text>
                                    @endforeach
                                </div>
                            @endforeach
                            <flux:separator class="mt-2 mb-2" />
                            <div class="flex items-center justify-end gap-2">
                                <flux:button size='sm' wire:click="closeModal" variant="ghost"
                                    style="cursor: pointer">Tutup
                                </flux:button>

                                <flux:button size='sm' wire:click="back(2)" variant="primary"
                                    style="cursor: pointer">
                                    Kembali
                                </flux:button>
                            </div>
                        </div>
                    @endif
                </div>
                @if ($currentStep === 4)
                <div>
                    <flux:heading size="lg" class="mb-4">
                       Pergi ke halaman pembayaran
                    </flux:heading>
                     <!--  -->
                    <div class="flex flex-col gap-4">
                        <flux:text class="text-xs">Anda akan diarahkan ke halaman pembayaran.</flux:text>

                        <flux:separator class="mt-2 mb-2" />
                        <div class="flex items-center justify-end gap-2">
                            <flux:button size='sm' wire:click="redirectToExternal" variant="primary" color="green" class="cursor-pointer">
                                Lanjutkan
                            </flux:button>

                            <flux:button size='sm' wire:click="back(2)" variant="ghost" class="cursor-pointer">
                                Kembali
                            </flux:button>
                        </div>
                    </div>
                </div>

                @endif
                @if ($tripay->mode === 'development')
                    <flux:text>
                        <flux:badge icon="bell-alert" color="red">
                            Penting!!!
                        </flux:badge>
                    </flux:text>
                    <flux:text class="text-red-700">
                        Saat notifikasi <flux:badge icon="bell-alert" color="amber" size="sm">Demo
                        </flux:badge> terlihat, jangan melakukan pembayaran apapun!
                    </flux:text>
                @endif
            </div>
        </flux:modal>

        @script
            <script wire-navigate-once>
                $js('refreshData', () => {
                    $wire.dispatch('refresh-invoice-list');
                })
            </script>
        @endscript
    @endif
</div>
