<div class="md:flex justify-center">
    <div class="space-y-4 md:w-120">
        <!--Informasi Paket-->
        @forelse (auth()->user()->customer_pakets as $customerPaket)
            @if (!$customerPaket->online && !is_null($customerPaket->activation_date))
                <flux:callout icon="x-circle" variant="danger">
                    <flux:callout.heading>
                            Koneksi terputus
                    </flux:callout.heading>

                    <flux:callout.text>
                        Saat ini koneksi internet di
                            {{ $customerPaket->customer_installation_address->address }} sedang terputus. Silahkan
                            <flux:callout.link :href="route('pages.contact')" class="text-blue-800 cursor-pointer">hubungi petugas kami</flux:callout.link> untuk pengaduan gangguan.
                    </flux:callout.text>
                </flux:callout>
            @endif
        @empty
            <flux:callout icon="information-circle" variant="warning">
                <flux:callout.heading>
                    Informasi Paket
                </flux:callout.heading>

                <flux:callout.text>
                    Ups, kamu belum berlangganan internet kepada kami. Rugi lho kalo tidak menggunakan layanan internet dari kami karena banyak fitur dan promo menarik.
                    Untuk mulai berlangganan, <flux:callout.link :href="route('pages.contact')" class="text-blue-800 cursor-pointer">hubungi kami</flux:callout.link> sekarang juga.
                </flux:callout.text>
            </flux:callout>
        @endforelse

        <!--Informasi Tagihan-->
        @if (auth()->user()->invoices->where('status', '!=', 'paid')->count())
            <flux:callout icon="information-circle" variant="warning">
                <flux:callout.heading>
                    Informasi Tagihan
                </flux:callout.heading>

                <flux:callout.text>
                    Anda memiliki {{ auth()->user()->invoices->where('status', '!=', 'paid')->count() }} tagihan
                    belum dibayar. Segera lakukan pembayaran untuk menghindari pemblokiran oleh system.
                </flux:callout.text>
                <x-slot name="actions">
                    <flux:button class="cursor-pointer" variant="primary" color="green" :href="route('customer.paymentmanagement')" size="xs" wire:navigate>Perpanjang Sekarang</flux:button>
                </x-slot>
            </flux:callout>
        @endif

        <!--Informasi Kelengkapan profile-->
        @if ($notCompleteProfile)
            <flux:callout icon="user-circle" variant="warning">
                <flux:callout.heading>
                    Lengkapi Profile
                </flux:callout.heading>

                <flux:callout.text>
                    Lengkapi profile anda untuk mendapatkan pelayanan maksimal dari kami.
                </flux:callout.text>
                <x-slot name="actions">
                    <flux:button class="cursor-pointer" variant="primary" color="green" :href="route('settings.profile')" size="xs" wire:navigate>
                        Lengkapi Profile
                    </flux:button>
                </x-slot>
            </flux:callout>

        @endif

        @if ($notCompleteAddress)
            <flux:callout icon="home" variant="warning">
                <flux:callout.heading>
                    Lengkapi Alamat
                </flux:callout.heading>

                <flux:callout.text>
                    Lengkapi anda anda agar kami lebih mudah menemukan rumah anda saat terjadi gangguan.
                </flux:callout.text>
                <x-slot name="actions">
                    <flux:button class="cursor-pointer" variant="primary" color="green" :href="route('settings.address') " size="xs" wire:navigate>
                        Lengkapi Alamat
                    </flux:button>
                </x-slot>
            </flux:callout>
        @endif

        <div class="flex flex-col gap-4">
        <flux:heading>Selamat datang kembali, {{ auth()->user()->full_name }}</flux:heading>
        <flux:heading>Saat ini kamu sedang berlangganan paket internet di bawah ini:</flux:heading>
        @forelse (auth()->user()->customer_pakets as $customerPaket)

            <div class="rounded-xl border bg-white dark:bg-stone-950 dark:border-stone-800 text-stone-800 shadow-xs">
                <div class="px-4 py-4">
                    <div class="gap-2 flex md:flex-row flex-col">
                        Status Koneksi:
                        @if (is_null($customerPaket->activation_date))
                        <flux:badge icon="bell-alert" color="sky">Menunggu Aktivasi</flux:badge>
                        @else
                        <flux:badge icon="bell-alert" color="{{ $customerPaket->online ? 'teal' : 'red' }}">
                            {{ $customerPaket->online ? 'Terhubung' : 'Terputus' }}</flux:badge>
                        @endif

                        @php
                        $nowDate = new DateTime(\Carbon\Carbon::now()->startOfDay());
                        $deadline = new DateTime($customerPaket->expired_date);
                        $interval_day = $nowDate->diff($deadline)->format('%a');

                        @endphp
                        @if (\Carbon\Carbon::now()->lt($customerPaket->expired_date) && $interval_day > 0 && $interval_day <
                            6) <flux:badge icon="bell-alert" color="orange">
                            {{ $interval_day }} hari lagi terblokir.
                            </flux:badge>
                            @endif
                    </div>

                    <flux:separator class="mt-2 mb-2" />

                    <div class="flex justify-between mb-2 mt-2">
                        <div class="flex justify-start">
                            <flux:heading>{{ $customerPaket->paket->name }}</flux:heading>
                        </div>
                    </div>

                    @if (!is_null($customerPaket->activation_date))
                    <div class="flex justify-between mb-2 mt-2 md:flex-row flex-col">
                        <div class="flex justify-start">
                            <flux:heading>Masa Aktif</flux:heading>
                        </div>
                        <div class="flex justify-between">
                            <flux:heading>
                                {{ \Carbon\Carbon::parse($customerPaket->start_date)->format('d M Y') }} -
                                {{ \Carbon\Carbon::parse($customerPaket->expired_date)->format('d M Y') }}
                            </flux:heading>
                        </div>
                    </div>
                    @endif
                    <div class="flex justify-between mb-2 mt-2 md:flex-row flex-col">
                        <div class="flex justify-start">
                            <flux:heading>Periode Pembayaran</flux:heading>
                        </div>
                        <div class="flex justify-between">
                            <flux:heading>{{ Str::apa($customerPaket->renewal_period) }}</flux:heading>
                        </div>
                    </div>
                    <div class="flex justify-between mb-2 mt-2 md:flex-row flex-col">
                        <div class="flex justify-start">
                            <flux:heading>Biaya Layanan (Belum termasuk pajak)</flux:heading>
                        </div>
                        <div class="flex justify-between">
                            <flux:heading>@moneyIDR($customerPaket->price) </flux:heading>
                        </div>
                    </div>
                </div>
            </div>

        @empty
            <flux:callout>
                <flux:callout.heading icon="newspaper">Langganan Paket</flux:callout.heading>
                <flux:callout.text>
                    Ups, kamu belum berlangganan internet kepada kami. Rugi lho kalo tidak menggunakan layanan internet dari kami karena banyak fitur dan promo menarik.
                    Untuk mulai berlangganan, <flux:callout.link href="{{ route('pages.contact') }}">hubungi kami</flux:callout.link> sekarang juga.
                </flux:callout.text>
            </flux:callout>
        @endforelse
        </div>
    </div>
</div>
