<section class="w-full">
    @include('partials.settings-heading')

    <x-settings.layout :heading="__('address.address')" :subheading="__('Update your general address')">
        <flux:separator class="md:hidden" />

        <div class="space-y-6">
            <div class="grid md:grid-cols-2 gap-1">
                <flux:text class="text-sm">{{ trans('address.general-address') }}</flux:text>
                <div>
                    <flux:text class="text-sm">{{ $user->user_address->address }}</flux:text>
                    <flux:text class="text-sm">{{ $user->user_address->subdistrict }}</flux:text>
                    <flux:text class="text-sm">{{ $user->user_address->district }}</flux:text>
                    <flux:text class="text-sm">{{ $user->user_address->city }}</flux:text>
                    <flux:text class="text-sm">{{ $user->user_address->province }}</flux:text>
                    <flux:text class="text-sm">{{ $user->user_address->country }}</flux:text>
                </div>
            </div>

            <flux:separator class="md:hidden" />

            <div class="grid md:grid-cols-2 gap-1">
                <flux:text class="text-sm">{{ trans('address.phone') }}</flux:text>
                <flux:text class="text-sm">{{ $user->user_address->phone }}</flux:text>
            </div>

            <div class="grid md:grid-cols-2 gap-1">
                <flux:text class="text-sm">{{ trans('address.wa-notification') }}</flux:text>
                <flux:text class="text-sm">
                    {{ $user->user_address->wa_notification ? trans('address.yes') : trans('address.no') }}
                </flux:text>
            </div>
        </div>
    </x-settings.layout>
</section>
