<?php

use App\Models\WhatsappGateway\WhatsappGatewayGeneral;
use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');


//Schedule::command('invoices:create-invoices')->everyMinute();
//Schedule::command('invoices:send-reminders')->everyMinute();
//Schedule::command('isolir:process-auto-isolir')->everyMinute();
Schedule::command('invoices:create-invoices')->dailyAt(env('CREATE_INVOICE_TIME', '08:00'));
Schedule::command('invoices:send-reminders')->dailyAt(env('WA_REMINDER_TIME', '10:00'));
Schedule::command('isolir:process-auto-isolir')->dailyAt(env('PROCESS_AUTOISOLIR_TIME', '23:50'));
Schedule::command('model:prune')->daily();
Schedule::command('file:delete-old-bulk-invoice')->daily();
Schedule::command('bootmessage:process-delete-user-boot-message')->everyFiveMinutes();
